<?php

class CollegeSearchController extends Controller {
    public $activeMenuLink = 'College search';
    public function init() {
        parent::init();


        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        set_time_limit(0);

    }

    public function actionIndex() {

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        $this->canonicalUrl = 'https://www.univariety.com/app/collegeSearch';
        $this->metaDesc = 'College search tools-search colleges in India & abroad. Start your college search to find colleges, universities of your choice.  Search from 2000+ colleges across India & globe.';
        $this->metaKeyword = 'search colleges, search colleges in india, college search tools';
        $this->setPageTitle('College Search Tools- Search Colleges in India & Abroad');

        if( Yii::app()->session->get('user_type_ref_id') == 2 ) {
            $this->breadcrumbs=array(
                'Home'=>array('/home'),
                'Decision Support Tools'=>array('/css/decisionSupportTools'),
                'College Search',
            );
        } else {
            $this->breadcrumbs=array(
                'Home'=>array('/home'),
                'College Search',
            );
        }

        if(!Yii::app()->request->isAjaxRequest){
            unset(Yii::app()->session['boardId']);
            unset(Yii::app()->session['overallMarks']);
            unset(Yii::app()->session['department']);
            unset(Yii::app()->session['countryId']);

        }

        $departmentId=$_GET['departmentId'];
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 'DISTINCT t.board_id, t.board_desc';
        $cdbCriteria->order= 't.board_desc';
        /*$boardLookup12 = LookupBoardEquivalent::GetSchoolBoardList('12');
        $boardList = CHtml::listData($boardLookup12, 'board_equivalent_id', 'board_desc');*/
        $boardList = LookupBoardEquivalent::getBoardCategoryByClass('12','',true);

        $departmentList = LookupDepartment::getMainDepartmentList();
        $shortListData = array();
        $shortlistCount = 0;
        $shortList = new ShortListEngine();
        $shortListData = $shortList->getShortList();
        foreach ($shortListData as $key=>$val) {
            if($val['intent'] != 'Reject'){
                $shortlistCount++;
            }
        }

        $modelData = new ChanceOfAdmissionData('checkChances');

        if (isset($_POST['ajax'])) {
            echo CActiveForm::validate($modelData);
            Yii::app()->end();
        }
        $loginFlag=false;
        $loginId = Yii::app()->user->id;
        if($loginId>0){
            $userType = Yii::app()->user->user_type_ref_id;
        }
        $collegeListId = $collegeList = array();
        if ($loginId > 0 && $userType == 1 ) {
            $loginFlag = true;
            $getScoreData = false;

            // read the data from profile
            $sql = "SELECT user_id FROM tbl_user_master WHERE login_ref_id=".$loginId;
            $userId =Yii::app()->db->createCommand($sql)->queryScalar();

            $sql = "SELECT board_ref_id, overall_marks, student_education_id FROM student_education WHERE user_ref_id=".$userId." AND class_level='12'";
            $educationResult = Yii::app()->db->createCommand($sql)->queryAll();
            $stud_board_id = $educationResult[0]['board_ref_id'];

            if($stud_board_id != NULL) {
                $sql = "SELECT overall_type FROM lookup_board_equivalent WHERE board_equivalent_id=".$stud_board_id;
                $stud_overall_type = strtolower(Yii::app()->db->createCommand($sql)->queryScalar());
                if($stud_overall_type != "grades") {
                    $stud_overall_marks = $educationResult[0]['overall_marks'];
                } else {
                    $student_edu_ref_id = $educationResult[0]['student_education_id'];
                    $sql = "SELECT grade_ref_id, grade_count FROM student_grade_count WHERE student_education_ref_id=".$student_edu_ref_id;
                    $result = Yii::app()->db->createCommand($sql)->queryAll();
                    $gradeArr = array();
                    foreach($result as $row) {
                        if($row['grade_ref_id'] == '1') {
                            $gradeArr['aa'] = intval($row['grade_count']);
                        } if($row['grade_ref_id'] == '2') {
                            $gradeArr['a'] = intval($row['grade_count']);
                        } if($row['grade_ref_id'] == '3') {
                            $gradeArr['b'] = intval($row['grade_count']);
                        } if($row['grade_ref_id'] == '4') {
                            $gradeArr['c'] = intval($row['grade_count']);
                        } if($row['grade_ref_id'] == '5') {
                            $gradeArr['d'] = intval($row['grade_count']);
                        }
                    }
                    $stud_overall_marks = json_encode($gradeArr);
                }
            }
            if(($stud_overall_marks == '') || ($stud_board_id == '') || ($stud_overall_type == '')  ) {
                $getScoreData = true;
            }
        }
        Yii::app()->session['boardId']=$stud_board_id;
        Yii::app()->session['overall_marks']=$stud_overall_marks;
        Yii::app()->session['educationType']=$stud_overall_type;
        $this->render("index", array('stud_board_id'=>$stud_board_id,'stud_overall_marks'=>$stud_overall_marks,'stud_overall_type'=>$stud_overall_type,'getScoreData'=>$getScoreData,'LoginFlag'=>$loginFlag,'boards'=>$boardList,'modelData'=>$modelData,'deptList'=>$departmentList,'shortlistCount'=>$shortlistCount),false,true);
    }

    public function actionPrefferedCollegeList() {

        $this->render("prefferedCollegelist");
    }

    public function actionGetCityList(){
        $countryId = Yii::app()->request->getParam('countryId');
        $cityList = TblCityMaster::model()->getCityListByCountryColleges($countryId);
        echo '<div class="row multi_line no-gutter">';
        echo '<div class="row multi_line no-gutter"><strong><input type="checkbox" rel="allcities1" class="allcitiess">All Cities</input></strong></div>';
        foreach($cityList as $id => $name){
            echo '<div class="row multi_line no-gutter small_gutter_l">';
            echo '<input type="checkbox" id="city1" name=city[] checked="checked"  value="'.$id.'" class="small_gutter_r childchkbx3 allcities1 " />';
            echo '<small>'.$name.'</small>';
            echo '</div>';
        }
        echo '</div>';
    }
    public function actionGetCityListOfIndia(){
        $countryId = Yii::app()->request->getParam('countryId');
        echo '<div class="row multi_line no-gutter"><strong><input type="checkbox" checked="checked"  class="small_gutter_r selectallcheckbox" >All Cities</input></strong></div>';
        $cityList['Metro']= TblCityMaster::model()->getCityListOfIndiaOfMetro($countryId);
        echo '<div id="startingdiv">';
        echo '<div class="row multi_line no-gutter">';
        echo '<div class="row multi_line no-gutter"><strong><input type="checkbox"  rel="metro" class="small_gutter_r citiesgroup">Metro</input></strong></div>';
        foreach($cityList['Metro'] as $id => $name){
            echo '<div class="row multi_line no-gutter small_gutter_l">';
            echo '<input type="checkbox" id="city1" name=city[]  value="'.$id.'" class="small_gutter_r indiaCity childchkbx1 metro">';
            echo '<small>'.$name.'</small>';
            echo '</div>';
        }
        echo '</div>';
        $cityList['Tier-1'] = TblCityMaster::model()->getCityListOfIndiaOfTier1($countryId);
        echo '<div class="row multi_line no-gutter">';
        echo '<div class="row multi_line no-gutter"><strong><input type="checkbox"  rel="tier-1" class="small_gutter_r citiesgroup">Tier-1</input></strong></div>';
        foreach($cityList['Tier-1'] as $id => $name){
            echo '<div class="row multi_line no-gutter small_gutter_l">';
            echo '<input type="checkbox" name=city[] id="city1" value="'.$id.'"  class="small_gutter_r indiaCity childchkbx1 tier-1">';
            echo '<small>'.$name.'</small>';
            echo '</div>';
        }
        echo '</div>';
        $cityList['Tier-2'] = TblCityMaster::model()->getCityListOfIndiaOfTier2($countryId);
        echo '<div class="row multi_line no-gutter">';
        echo '<div class="row multi_line no-gutter"><strong><input type="checkbox"  rel="tier-2" class="small_gutter_r citiesgroup">Tier-2</input></strong></div>';

        foreach($cityList['Tier-2'] as $id => $name){
            echo '<div class="row multi_line no-gutter small_gutter_l">';
            echo '<input type="checkbox" name=city[] id="city1" value="'.$id.'" class="small_gutter_r indiaCity childchkbx1 tier-2">';
            echo '<small>'.$name.'</small>';
            echo '</div>';
        }
        echo '</div>';
        $cityList['Others'] = TblCityMaster::model()->getCityListOfIndiaOfOthers($countryId);
        echo '<div class="row multi_line no-gutter">';
        echo '<div class="row multi_line no-gutter "><strong><input type="checkbox"  rel="others" class="small_gutter_r citiesgroup">Others</input></strong></div>';
        foreach($cityList['Others'] as $id => $name){
            echo '<div class="row multi_line no-gutter small_gutter_l">';
            echo '<input type="checkbox" name=city[] id="city1" value="'.$id.'" class="small_gutter_r indiaCity childchkbx1 others">';
            echo '<small>'.$name.'</small>';
            echo '</div>';
        }
        echo '</div>';
        echo '</div>';
    }

    public function actionGetStateListOfIndia()
    {
        $countryId = Yii::app()->request->getParam('countryId');
        echo '<div class="row multi_line no-gutter"><strong><input type="checkbox" checked="checked" rel="allcities" class="small_gutter_r selectallcheckbox" >All States</input></strong></div>';

        $stateList['East India']= TblState::model()->getStateListOfIndiaOfEast($countryId);
        echo '<div id="startingdiv">';
        echo '<div class="row multi_line no-gutter">';
        echo '<div class="row multi_line no-gutter "><strong><input type="checkbox"   rel="east_india" class="small_gutter_r statesgroup">East India</input></strong></div>';

        foreach($stateList['East India'] as $id => $name){

            echo '<div class="row multi_line no-gutter small_gutter_l">';
            echo '<input type="checkbox" id="state1" name=state[]  value="'.$id.'" class="small_gutter_r indiaCity childchkbx east_india"/>';
            echo '<small>'.$name.'</small>';
            echo '</div>';
        }
        echo '</div>';

        $stateList['North India'] = TblState::model()->getStateListOfIndiaOfNorth($countryId);
        echo '<div class="row multi_line no-gutter">';
        echo '<div class="row multi_line no-gutter"><strong><input type="checkbox"  rel="north_india" class="small_gutter_r statesgroup">North India</input></strong></div>';


        foreach($stateList['North India'] as $id => $name){

            echo '<div class="row multi_line no-gutter small_gutter_l">';
            echo '<input type="checkbox" name=state[] id="state1" value="'.$id.'" class="small_gutter_r indiaState childchkbx north_india" />';

            echo '<small>'.$name.'</small>';
            echo '</div>';
        }
        echo '</div>';


        $stateList['Northeast India'] = TblState::model()->getStateListOfIndiaOfNortheast($countryId);
        echo '<div class="row multi_line no-gutter">';
        echo '<div class="row multi_line no-gutter"><strong><input type="checkbox"  rel="northeast_india" class="small_gutter_r statesgroup">Northeast India</input></strong></div>';

        foreach($stateList['Northeast India'] as $id => $name){

            echo '<div class="row multi_line no-gutter small_gutter_l">';
            echo '<input type="checkbox" name=state[] id="state1"  value="'.$id.'" class="small_gutter_r indiaState childchkbx northeast_india" >';
            echo '<small>'.$name.'</small>';
            echo '</div>';
        }
        echo '</div>';


        $stateList['South India'] = TblState::model()->getStateListOfIndiaOfSouth($countryId);
        echo '<div class="row multi_line no-gutter ">';
        echo '<div class="row multi_line no-gutter "><strong><input type="checkbox"  rel="south_india" class="small_gutter_r statesgroup">South India</input></strong></div>';

        foreach($stateList['South India'] as $id => $name){

            echo '<div class="row multi_line no-gutter small_gutter_l">';
            echo '<input type="checkbox" name=state[] id="state1" value="'.$id.'" class="small_gutter_r indiaState childchkbx south_india" >';
            echo '<small>'.$name.'</small>';
            echo '</div>';
        }
        echo '</div>';

        $stateList['West India'] = TblState::model()->getStateListOfIndiaOfWest($countryId);
        echo '<div class="row multi_line no-gutter">';
        echo '<div class="row multi_line no-gutter "><strong><input type="checkbox"  rel="west_india" class="small_gutter_r statesgroup">West India</input></strong></div>';

        foreach($stateList['West India'] as $id => $name){
            echo '<div class="row multi_line no-gutter small_gutter_l">';
            echo '<input type="checkbox" name=state[] id="state1" value="'.$id.'" class="small_gutter_r childchkbx indiaState west_india"  />';
            echo '<small>'.$name.'</small>';
            echo '</div>';
        }
        echo '</div>';
        echo '</div>';
    }
    public function actionGetCityListOfUs(){
        $countryId = Yii::app()->request->getParam('countryId');
        $cityList = TblCityMaster::model()->getCityListByCountryColleges($countryId);
        echo '<div class="row multi_line no-gutter">';
        echo '<div class="row multi_line no-gutter"><strong><input type="checkbox"  rel="allcitiesus" class="small_gutter_r allcitiesofus">All Cities</input></strong></div>';

        foreach($cityList as $id => $name){
            echo '<div class="row multi_line no-gutter">';
            echo '<input type="checkbox"  name=city[]  id="city1" value="'.$id.'" class="small_gutter_r usCity childchkbx2 allcitiesus">';
            echo '<small>'.$name.'</small>';
            echo '</div>';
        }
        echo '</div>';

    }


    public function actionGetStateList(){
        $countryId = Yii::app()->request->getParam('countryId');
        $stateList = TblState::model()->getStateByCountry($countryId);
        echo '<div class="row multi_line no-gutter">';
        echo '<div class="row multi_line no-gutter"><strong><input type="checkbox"  rel="stateofus" class="small_gutter_r statesofus">All states</input></strong></div>';

        foreach($stateList as $id => $name){
            echo '<div class="row multi_line no-gutter">';
            echo '<input type="checkbox" name=state[]  id="state1" value="'.$id.'"  class="small_gutter_r state childchkbx2 stateofus">';
            echo '<small>'.$name.'</small>';
            echo '</div>';
        }
        echo '</div>';

    }



    public function actionGetCityListByState(){
        $countryId = Yii::app()->request->getParam('countryId');
        $stateId = Yii::app()->request->getParam('stateId');
        $cityList = TblCityMaster::model()->getCityListByStateColleges($stateId);
        $cityList1=array('0'=>'Choose a city');
        echo CHtml::listOptions('',$cityList1+$cityList);

    }

    public function actionGetSubDeptList(){
        $deptId = Yii::app()->request->getParam('deptId');
        $modelSubDept = LookupDepartment::getSubDepartmentsList($deptId);
        $subDeptList = CHtml::listData($modelSubDept,'department_id', 'department_name');
        echo json_encode($subDeptList);
    }

    public function actionGetCollegeSearchResult()
    {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        $limit = 10;
        $offset = isset($_GET['offset']) ? $_GET['offset'] : 0;

        $departmentList = LookupDepartment::getMainDepartmentList();
        /*$boardLookup12 = LookupBoardEquivalent::GetSchoolBoardList('12');
        $boardList = CHtml::listData($boardLookup12, 'board_equivalent_id', 'board_desc');*/
        $boardList = LookupBoardEquivalent::getBoardCategoryByClass('12','',true);

        if(!Yii::app()->request->getParam('dataflag',0))
        {
            unset(Yii::app()->session['countryId']);
            unset(Yii::app()->session['state']);
            unset(Yii::app()->session['city']);
            unset(Yii::app()->session['subDeptId']);
            unset(Yii::app()->session['otherSubDepartment']);
            unset(Yii::app()->session['department']);
            unset(Yii::app()->session['location_type']);
            unset(Yii::app()->session['college_size']);
            unset(Yii::app()->session['uni_gender']);
            unset(Yii::app()->session['vintage']);
            unset(Yii::app()->session['international_student']);
            unset(Yii::app()->session['popular_course_list']);
            unset(Yii::app()->session['study_level']);
            unset(Yii::app()->session['acceptance_rate']);
        }

        $country = Yii::app()->request->getParam('country',null);
        if($country){
            Yii::app()->session['countryId'] = $country;
        }else{
            $country = Yii::app()->session['countryId'];
        }
        if($country){
            $params['country'] = $country;
        }
		
		$country_name_list=TblCountryMaster::model()->findByPk($country);
		if(!empty($country_name_list))
			$country_name=$country_name_list->country_name;
		else $country_name="";
		
        $state = Yii::app()->request->getParam('state',null);
        if($state){
            Yii::app()->session['state'] = $state;
        }else{
            $state = Yii::app()->session['state'];
        }
        if($state){
            $params['state'] = $state;
        }

        $city = Yii::app()->request->getParam('city',null);
        if($city)
        {
            Yii::app()->session['city']=$city;

        }
        else{
            $city=Yii::app()->session['city'];

        }
        if($city){
            $params['city'] = $city;
        }

        $department = Yii::app()->request->getParam('department',null);
        if($department)
        {
            Yii::app()->session['department']=$department;

        }
        else{
            $department=Yii::app()->session['department'];

        }
        if($department){
            $params['department'] = $department;
        }
		
		$select_dept_list=lookupdepartment::model()->findByPk($department);
		if(!empty($select_dept_list))
			$department_name=$select_dept_list->department_name;
		else $department_name="";
		
        $subDepartmentId = Yii::app()->request->getParam('subDeptId',null);
        if($subDepartmentId)
        {
            Yii::app()->session['subDeptId']=$subDepartmentId;

        }
        else{
            $subDepartmentId=Yii::app()->session['subDeptId'];

        }
        if($subDepartmentId){
            $params['subDeptId'] = $subDepartmentId;
        }


        $otherDepartment = Yii::app()->request->getParam('other_sub_dept_pref',null);
        if($otherDepartment)
        {
            Yii::app()->session['otherSubDepartment']=$otherDepartment;

        }
        else{
            $otherDepartment=Yii::app()->session['otherSubDepartment'];

        }
        if($otherDepartment){
            $params['otherSubDepartment'] = $otherDepartment;
        }


        $locationType = Yii::app()->request->getParam('location_type',null);
        if($locationType)
        {
            Yii::app()->session['location_type']=$locationType;

        }
        else{
            $locationType=Yii::app()->session['location_type'];

        }
        if($locationType){
            $params['location_type'] = $locationType;
        }

        $acceptanceRate = Yii::app()->request->getParam('acceptance_rate',null);
        if($acceptanceRate)
        {
            Yii::app()->session['acceptance_rate']=$acceptanceRate;

        }
        else{
            $acceptanceRate=Yii::app()->session['acceptance_rate'];

        }
        if($acceptanceRate){
            $params['acceptance_rate'] = $acceptanceRate;
        }


        $vintage = Yii::app()->request->getParam('vintage',null);
        if($vintage)
        {
            Yii::app()->session['vintage']=$vintage;

        }
        else{
            $vintage=Yii::app()->session['vintage'];

        }
        if($vintage){
            $params['vintage'] = $vintage;
        }


        $collegeSize = Yii::app()->request->getParam('college_size',null);
        if($collegeSize)
        {
            Yii::app()->session['college_size']=$collegeSize;

        }
        else{
            $collegeSize=Yii::app()->session['college_size'];

        }
        if($collegeSize){
            $params['college_size'] = $collegeSize;
        }



        $uniGender = Yii::app()->request->getParam('uni_gender',null);
        if($uniGender)
        {
            Yii::app()->session['uni_gender']=$uniGender;

        }
        else{
            $uniGender=Yii::app()->session['uni_gender'];

        }
        if($uniGender){
            $params['uni_gender'] = $uniGender;
        }


        $studyLevel = Yii::app()->request->getParam('study_level',null);
        if($studyLevel)
        {
            Yii::app()->session['study_level']=$studyLevel;
        }
        else{
            $studyLevel=Yii::app()->session['study_level'];

        }
        if($studyLevel){
            $params['study_level'] = $studyLevel;
        }


        $internationalStudent = Yii::app()->request->getParam('international_student',null);
        if($internationalStudent)
        {
            Yii::app()->session['international_student']=$internationalStudent;
        }
        else{
            $internationalStudent=Yii::app()->session['international_student'];

        }
        if($internationalStudent){
            $params['international_student'] = $internationalStudent;
        }

        $course = Yii::app()->request->getParam('popular_course_list',null);
        if($course)
        {
            Yii::app()->session['popular_course_list']=$course;
        }
        else{
            $course=Yii::app()->session['popular_course_list'];

        }
        if($course){
            $params['popular_course_list'] = $course;
        }

        $submitType = Yii::app()->request->getParam('submitType');
        if($submitType !=''){
            $params['submitType'] = $submitType;
        }
        $loginId = Yii::app()->user->id;
        if($loginId>0)
        {
            $userType = Yii::app()->user->user_type_ref_id;
        }
        $loginFlag = false;
        $shortList = array();
        if ($loginId > 0 && $userType == 1 )
        {
            $loginFlag = true;

        }
        $collegeListId = array();
        $shortList = new ShortListEngine();
        $shortListData = $shortList->getShortList();
        foreach ($shortListData as $key=>$val) {
            if($val['intent'] != 'Reject'){
                $collegeListId[$key] = $key;
                $shortlistCount++;
            }
        }
        $modelData = new ChanceOfAdmissionData('checkChances');
        if (isset($_POST['ajax'])) {
            echo CActiveForm::validate($modelData);
            Yii::app()->end();
        }

        if(count($params)>0){
            $gridData = TblUniversityMaster::getCollegeSearchResult($offset,$limit,$params);

        }



        $recordscomplete = count($gridData) == 0 ? true : false;
        if ($_GET['sub_view'] == 'sub_view') {
            $this->renderPartial('_search_results_sub', array('subDepartmentId'=>$subDepartmentId,'LoginFlag'=>$loginFlag,'recordscomplete'=>$recordscomplete,'departmentId'=>$department,'countryId'=>$country,'limit'=>$limit,'offset'=>$offset,'departmentList'=> $departmentList, 'modelData'=>$modelData,'gridData' => $gridData,'params'=>$params,'studentShortListColleges'=>$collegeListId,'loginCheck'=>$loginFlag,'boards'=>$boardList),false,true);
        }
        else{
            $this->renderPartial('_search_results', array('subDepartmentId'=>$subDepartmentId,'LoginFlag'=>$loginFlag,'recordscomplete'=>$recordscomplete,'departmentId'=>$department,'countryId'=>$country,'limit'=>$limit,'offset'=>$offset,'departmentList'=> $departmentList, 'modelData'=>$modelData,'gridData' => $gridData,'params'=>$params,'studentShortListColleges'=>$collegeListId,'loginCheck'=>$loginFlag,'boards'=>$boardList,'department_name'=>$department_name,'country_name'=>$country_name),false,true);
        }
    }

    public function actionGetCompareCollege() {

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        $collegeListId = $collegeList = array();
        if ($loginId > 0 && $userType == 1 ) {
            $loginFlag = true;
        }
        $shortListData = $collegeListId = array();
        $shortList = new ShortListEngine();
        $shortListData = $shortList->getShortList();
        $shortlistCount = 0;
        foreach ($shortListData as $key=>$val) {
            if($val['intent'] != 'Reject'){
                $collegeListId[$key] = $key;
                $shortlistCount++;
            }
        }
        $compareuniversities = array();
        $cntlistarr = count($compareIds);
        $universityFlag = array();
        foreach ($compareIds as $universityId) {
            $countryId = TblUniversityMaster::getUniCountryName($universityId);
            $currentUniversityData = TblUniversityMaster::model()->findByAttributes(array('uni_id'=>$universityId,'is_active'=>'Y'));
            $compareuniversities[] = $currentUniversityData;
            if($currentUniversityData['acceptance_rate']!= NULL && $currentUniversityData['acceptance_rate']!= '' ){
                $universityFlag['acceptance_rate'] = true;
            }
            if($currentUniversityData['main_campus_size_in_acres']!= NULL && $currentUniversityData['main_campus_size_in_acres']>0 ){
                $universityFlag['main_campus_size_in_acres'] = true;
            }
            if($currentUniversityData['no_of_campus']!= NULL && $currentUniversityData['no_of_campus']>0 ){
                $universityFlag['no_of_campus'] = true;
            }
            if($currentUniversityData['international_stud_per']!= NULL && $currentUniversityData['international_stud_per']>0 ){
                $universityFlag['international_stud_per'] = true;
            }
            if($currentUniversityData['total_students']!= NULL && $currentUniversityData['total_students']>0 ){
                $universityFlag['total_students'] = true;
            }
            if($currentUniversityData['living_cost_in_city']!= NULL && $currentUniversityData['living_cost_in_city']!= '' ){
                $universityFlag['living_cost_in_city'] = true;
            }
            if($currentUniversityData['living_cost_on_campus']!= NULL && $currentUniversityData['living_cost_on_campus']!= '' ){
                $universityFlag['living_cost_on_campus'] = true;
            }
            if($currentUniversityData['calender_system']!= NULL && $currentUniversityData['calender_system']!= '' ){
                $universityFlag['calender_system'] = true;
            }

            $universityCourseCount = TblUniCourses::getCourseCountByUniversityId($universityId, 'ug');
            if($universityCourseCount){
                $universityData['ug_course_count'][$universityId] = $universityCourseCount;
            }

            $feesData = UniversityCostSummary::getAvgUniversityFeesById($universityId);
            if ($feesData->fees_per_year > 0 && $feesData->fees_per_year != null && $feesData->currency_ref_id != NULL) {
                if($feesData->currency_ref_id==1){
                    $universityData['avg_fees'][$universityId] = '<span class="WebRupee">Rs. </span> ' . number_format($feesData->fees_per_year) . ' / Year';
                }else{
                    $universityData['avg_fees'][$universityId] = '<span class="WebRupee">Rs. </span> ' . number_format(LookupCurrencyConversion::convertCurrency($feesData->currency_ref_id, 1, $feesData->fees_per_year)) . ' / Year';
                }

            }
            $scholarshipCount = ScholarshipHostInstitute::getScholarshipCountByUniId($universityId);
            if($scholarshipCount){
                $universityData['total_scholarship_count'][$universityId] = $scholarshipCount;
            }
            $universityData[$universityId]['global_rank'] = UniversityDeptRanking::getUniversityGlobalRank($universityId);
            if($universityData[$universityId]['global_rank']->rank >0){
                $universityFlag['global_rank'] = true;
            }

            $universityData[$universityId]['country_rank'] = UniversityDeptRanking::getUniversityCountryRank($universityId);
            if($universityData[$universityId]['country_rank']->rank >0){
                $universityFlag['country_rank'] = true;
            }
            $universityData[$universityId]['short_list'] = 'plus';
            if(in_array($universityId, $collegeListId)){
                $universityData[$universityId]['short_list'] = 'tick';
            }

        }
        if(count($universityData['total_scholarship_count'])>0){
            $universityFlag['total_scholarship_count'] = true;
        }
        if(count($universityData['avg_fees'])>0){
            $universityFlag['avg_fees'] = true;
        }
        if(count($universityData['ug_course_count'])>0){
            $universityFlag['ug_course_count'] = true;
        }

        $modelData = new ChanceData('checkChances');
        if (isset($_POST['ajax'])) {
            echo CActiveForm::validate($modelData);
            Yii::app()->end();
        }

        /*$cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 'DISTINCT t.board_id, t.board_desc';
        $cdbCriteria->order= 't.board_desc';
        $model = LookupBoard::model()->findAll($cdbCriteria);
        $boardList = CHtml::listData($model, 'board_id', 'board_desc');*/
        $boardList = LookupBoardEquivalent::getBoardCategoryByClass('12',true,true);

        $dept_list = LookupDepartment::getMainDepartmentList();

        $this->setPageTitle(Yii::app()->name .' - Compare Colleges');
        if($_GET['ajax']){
            $this->renderPartial('_compareCollege', array(
                'compareuniversities' => $compareuniversities,
                'cntlist' => $cntlistarr,
                'universityData' => $universityData,
                'flag' => $flag,
                'loginFlag' => $loginFlag,
                'universityFlag'=> $universityFlag,
                'shortlistCount' => $shortlistCount,
                'model'=>$modelData,
                'boards'=>$boardList,
                'dept_list'=>$dept_list,

            ),false,true);
        }else{
            $this->render('getCompareColleges', array(
                'compareuniversities' => $compareuniversities,
                'cntlist' => $cntlistarr,
                'universityData' => $universityData,
                'flag' => $flag,
                'loginFlag' => $loginFlag,
                'universityFlag'=> $universityFlag,
                'shortlistCount' => $shortlistCount,
                'model'=>$modelData,
                'boards'=>$boardList,
                'dept_list'=>$dept_list,
            ));
        }

        Yii::app()->session['compareUniversityIds'] = null;
    }
    public function actionGetPopularCourseList(){
        $term = Yii::app()->request->getParam('term');
        if($term){
            $courseData = LookupPopularCourses::getPopularCourseList($term,10,true);
            foreach($courseData as $key=>$value){
                $res[] = array(
                    'id' => $value['main_dept_id'] ? $value['main_dept_id'] : $value['department_id'],
                    'label' => html_entity_decode($value['department_name']),
                    //'id' => $value['department_id'],
                    //'label' => html_entity_decode($value['course_name']),
                    'dept' => html_entity_decode($value['department_name'])

                );
            }
            echo CJSON::encode($res);
            Yii::app()->end();
        }
    }

    public function actionGetOverallAndSubjects()
    {

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        $classLevel = '12';
        $boardId = Yii::app()->request->getParam('boardId', 0);

        $departmentId=Yii::app()->request->getParam('departmentId',0);
        $boardDetails = LookupBoardEquivalent::GetBoardDetails($classLevel, $boardId);
        $overallMax = $boardDetails['overall_max'];
        $overallType = strtolower($boardDetails['overall_type']);

        $content = '<input type="hidden" id="ChanceOfAdmissionData_overall_type" name="ChanceOfAdmissionData[overall_type]" value="' . $overallType . '"><input type="hidden" id="ChanceOfAdmissionData_overall_max" name="ChanceOfAdmissionData[overall_max]" value="' . $boardDetails['overall_max'] . '" >';

        switch ($boardDetails['overall_type']) {
            case 'Marks-GPA':
            {
                $overAll = CHtml::textField('ChanceOfAdmissionData[overall_marks_gpa]', '', array('id' =>'ChanceOfAdmissionData_overall_marks_gpa', 'maxlength' => 3, 'placeholder' => 'Enter Overall Marks or CGPA', 'class' => 'grid_4'));
                $overAll .= '<div style="display:none" id="ChanceOfAdmissionData_overall_marks_gpa_em_" class="errorMessage popup"></div>';
                $html = '<div class="row visible clearfix gutter_vertical">
                <div class="left grid_2">
                    <strong>Overall Marks or CGPA</strong>
                </div>
                <div class="left grid_6 relative">
                '.$overAll.'
                </div>
                </div>';
                break;

            }
            case 'Grades':
            {
                $gradeList = range(1, $overallMax);
                $gradeList = array_combine($gradeList, $gradeList);
                $gradeList[0] = '--';
                ksort($gradeList);

                $overAll = '<div class="left relative">A* '.CHtml::dropDownList('ChanceOfAdmissionData[overall_grade_aa]', '', $gradeList, array( 'rel' => 'ChanceOfAdmissionData[overall_grade_aa]', 'id' => 'ChanceOfAdmissionData_overall_grade_aa', 'class'=>'grid_1'));
                $overAll .= '<div style="display:none; ;" id="ChanceOfAdmissionData_overall_grade_aa_em_" class="errorMessage popup"></div>'.'</div>';
                $overAll .= '<div class="left">A '.CHtml::dropDownList('ChanceOfAdmissionData[overall_grade_a]', '', $gradeList, array( 'rel' =>'ChanceOfAdmissionData[overall_grade_a]', 'id' => 'ChanceOfAdmissionData_overall_grade_a', 'class'=>'grid_1')).'</div>';

                $overAll .= '<div class="left">B '.CHtml::dropDownList('ChanceOfAdmissionData[overall_grade_b]', '', $gradeList, array( 'rel' => 'ChanceOfAdmissionData[overall_grade_b]', 'id' => 'ChanceOfAdmissionData_overall_grade_b', 'class'=>'grid_1')).'</div>';

                $overAll .= '<div class="left">C '.CHtml::dropDownList('ChanceOfAdmissionData[overall_grade_c]', '', $gradeList, array( 'rel' => 'ChanceOfAdmissionData[overall_grade_c]', 'id' => 'ChanceOfAdmissionData_overall_grade_c', 'class'=>'grid_1')).'</div>';
                $overAll .= '<div class="left">D '.CHtml::dropDownList('ChanceOfAdmissionData[overall_grade_d]', '', $gradeList, array( 'rel' => 'ChanceOfAdmissionData[overall_grade_d]', 'id' =>'ChanceOfAdmissionData_overall_grade_d', 'class'=>'grid_1')).'</div>';
                $overAll .= '<div class="left">E '.CHtml::dropDownList('ChanceOfAdmissionData[overall_grade_e]', '', $gradeList, array( 'rel' => 'ChanceOfAdmissionData[overall_grade_e]', 'id' =>'ChanceOfAdmissionData_overall_grade_e', 'class'=>'grid_1')).'</div>';
                $html = '<div class="row visible clearfix gutter_vertical">
                <div class="left grid_2">
                    <strong>Overall Grades</strong>
                </div>'.$overAll.'
                </div>';


                break;
            }
            case 'Marks': {
                $overAll = CHtml::textField('ChanceOfAdmissionData[overall_marks]', '', array('id' => 'ChanceOfAdmissionData_overall_' . $overallType , 'maxlength' => 3, 'placeholder' => 'Enter Overall Marks', 'class' => 'grid_4'));
                $overAll .= '<div style="display:none" id="ChanceOfAdmissionData_overall_marks_em_" class="errorMessage popup"></div>';

                $html = '<div class="row visible clearfix gutter_vertical">
                <div class="left grid_2">
                    <strong>Overall Marks</strong>
                </div>
                <div class="left grid_6 relative">
                '.$overAll.'
                </div>
                </div>';

                break;
            }
            case 'Points':
            {
                $pointsList = range(1, $overallMax);
                $pointsList = array_combine($pointsList, $pointsList);
                arsort($pointsList);

                $overAll = CHtml::dropDownList('ChanceOfAdmissionData[overall_points]', '', $pointsList, array('empty' => 'Points', 'id' => 'ChanceOfAdmissionData_overall_'.$overallType, 'class' => 'grid_4'));
                $overAll .= '<div style="display:none" id="ChanceOfAdmissionData_overall_'.$overallType.'_em_" class="errorMessage popup"></div>';

                $html = '<div class="row visible clearfix gutter_vertical">
                <div class="left grid_2">
                    <strong>Overall Points</strong>
                </div>
                <div class="left grid_6 relative">
                '.$overAll.'
                </div>
                </div>';

                break;
            }
        }
        echo $content.$html;

    }

    public function actionAddCollegeToShortList() {
        $universityId = Yii::app()->request->getParam('universityId');
        $needShortList = Yii::app()->request->getParam('shortList');
        $intent = Yii::app()->request->getParam('intent');
        if($needShortList==""){
            $needShortList = false;
        }
        $universityName = TblUniversityMaster::getUniversityName($universityId);
        $flag = false;
        if ($universityId != '') {
            $flag = true;
            $shortList = new ShortListEngine();
            try{
                if($intent!=''){
                    $shortList->saveToShortList($universityId,constant($intent));
                }else{
                    $shortList->saveToShortList($universityId);
                }
            }catch(Exception $e){
                $flag = false;
            }

        }
        $shortListObj = new ShortListEngine();
        $shortListData = $shortListObj->getShortList();
        $shortlistCount = 0;
        foreach ($shortListData as $key=>$val) {
            if($val['intent'] != 'Reject'){
                $shortlistCount++;
            }
        }
        $val = '';
        switch ($intent) {
            case 'SHORTLIST_MIGHTAPPLY':
                $val = str_replace('Apply', ' Apply', SHORTLIST_MIGHTAPPLY);break;
            case 'SHORTLIST_WILLAPPLY':
                $val = str_replace('Apply', ' Apply', SHORTLIST_WILLAPPLY);break;
            case 'SHORTLIST_APPLIED':
                $val = SHORTLIST_APPLIED;break;
        }
        echo json_encode(array("count" => "$shortlistCount", "flag" => "$flag","uni_name"=>"$universityName", 'status'=>$val));
    }

}