<?php

class ChrisalisController extends Controller {
	private $prodDb;

    public function init() {
        parent::init();

        $db = Yii::app()->request->getParam('db');
        $host = Yii::app()->request->getParam('host');
        $username = Yii::app()->request->getParam('username');
        $password = Yii::app()->request->getParam('password');

        $this->prodDb = new CDbConnection('mysql:host=' . $host  . ';dbname=' . $db, $username, $password);

    }

    private function _switchDB($name='local'){
        try{
            $this->prodDb;
        }catch(Exception $e) {
            echo "<h2>Net connection required.</h2>";
            $e->getMessage();
            exit;
        }
        CActiveRecord::$db = ($name == 'local') ? Yii::app()->db : $this->prodDb;
    }

    public function actionProductionSync() {

        ini_set('memory_limit', '1024M');
        ini_set('max_execution_time', '9600');
        /* Here we are get the records with not sync. i.e. is_sync is null */

        $sql = "SELECT user_id, username, login_ref_id, TIME_TO_SEC(TIMEDIFF(NOW(),lm.added_on))/3600 AS timee
        FROM `tbl_user_master` um
        INNER JOIN login_master lm ON lm.login_id = um.login_ref_id
        WHERE is_sync IS NULL AND um.signup_source_ref_id = 148
        ORDER BY login_id";
        $this->_switchDB('prodDb');
        try{
            $students = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        }catch(Exception $e) {
            echo "<h2>Net connection required.</h2>";
            $e->getMessage();
            exit;
        }
        $this->_switchDB('local');
        $students = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        echo "Total students found: ".count($students);

        foreach($students as $key => $student)
        {
        	$this->_switchDB('prodDb');
            $transaction = CActiveRecord::$db->beginTransaction();
            try
            {
                /* Connecting to Production Database */
                $this->_switchDB('prodDb');
                $exists = LoginMaster::model()->findByAttributes(array('username'=> $student->username));
                $this->_switchDB('local');
                if(count($exists)<1)
                {
                	$this->_switchDB('local');
                    /* Get the tables data form local DataBase */
                    $sql = "SELECT * FROM chrysalis_tables WHERE is_active='1' AND is_dependency='N' ORDER BY chrysalis_table_id ASC";
                    $tables = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();

                    foreach($tables as $k => $table)
                    {
                        $className = $table->class_name;
                        if($table->table_name == 'login_master'){
                            $tb = $className::model()->findByAttributes(array('username'=> $student->username));
                        }
                        else if($table->table_name == 'tbl_user_master'){
                            $tb = $className::model()->findByAttributes(array('login_ref_id'=> $student->login_ref_id));
                        }
                        if($table->table_type == 'Update') {
                            if(!in_array($table->table_name, array('tbl_user_master','login_master')) ) {
                                $tb = $className::model()->findByAttributes(array('user_ref_id'=> $student->user_id));
                            }
                        }

                        if($table->table_type == 'Insert') {
                            if(in_array($table->table_name, array('login_log','student_alternate_email')) ) {
                                $tb = $className::model()->findAllByAttributes(array('login_ref_id'=> $student->login_ref_id));
                            }
                            else if(in_array($table->table_name, array('student_overall_percent')) ) {
                                $tb = $className::model()->findAllByAttributes(array('student_ref_id'=> $student->user_id));
                            }
                            else if(in_array($table->table_name, array('rbac_authassignment')) ) {
                                $tb = $className::model()->findAllByAttributes(array('userid'=> $student->login_ref_id));
                            }
                            else {
                                $tb = $className::model()->findAllByAttributes(array('user_ref_id'=> $student->user_id));
                            }
                        }

                        /* Connecting to Production Database */
                        $this->_switchDB('prodDb');

                        if($table->table_type == 'Update') {
                            $res = new $className('search');
                            $res->attributes = $tb->attributes;
                        }

                        // Un set primary keys for tables
                        $primaryKey = $res->tableSchema->primaryKey;
                        unset($res->$primaryKey);
                        if($table->table_name == 'tbl_user_master'){
                            $res->login_ref_id = Yii::app()->session['login_id'];
                            $res->know_your_subjects = $tb->know_your_subjects;
                            $res->is_visited_school = $tb->is_visited_school;
                            $res->school_ref_id = NULL;
                        }
                        if($table->table_type == 'Insert') {
                            foreach($tb as $k => $record) {
                                $res = new $className('search');
                                $res->attributes = $record->attributes;
                                if(in_array($table->table_name, array('login_log','student_alternate_email')) ) {
                                    $res->login_ref_id = Yii::app()->session['login_id'];
                                    if($table->table_name == 'student_alternate_email') {
                                        $res->added_by = Yii::app()->session['login_id'];
                                        $res->modified_by = Yii::app()->session['login_id'];
                                    }
                                }
                                else if(in_array($table->table_name, array('student_preferred_department')) ) {
                                    $res->user_ref_id = Yii::app()->session['user_id'];
                                    $res->course_ref_id = NULL;
                                } else if (in_array($table->table_name, array('student_overall_percent')) ) {
                                    $res->student_ref_id = Yii::app()->session['user_id'];
                                }
                                else if(in_array($table->table_name, array('rbac_authassignment')) ) {
                                    $res->userid = Yii::app()->session['login_id'];
                                }
                                else {
                                    $res->user_ref_id = Yii::app()->session['user_id'];
                                    //echo '<pre>'; print_r($res->attributes); exit;
                                }

                                if(in_array($table->table_name, array('student_contact_number')) ){
                                    $res->added_by = Yii::app()->session['login_id'];
                                    $res->modified_by = Yii::app()->session['login_id'];
                                }
                                $primaryKey = $res->tableSchema->primaryKey;
                                unset($res->$primaryKey);
                                if(in_array($table->table_name, array('tbl_user_prof_critical_completion')) ) {
                                    $res->user_ref_id = Yii::app()->session['user_id'];
                                }
                                if(in_array($table->table_name, array('rbac_authassignment')) ) {
                                    $res->userid = Yii::app()->session['login_id'];
                                }
                                $res->save(false);
                            }
                        }

                        if($table->table_type == 'Update'){
                            $res->save(false);
                        }

                        if($table->table_name == 'login_master') {
                            Yii::app()->session['login_id'] = $res->login_id;
                        }
                        else if($table->table_name == 'tbl_user_master') {
                            Yii::app()->session['user_id'] = $res->user_id;
                        }
                        echo '++'.Yii::app()->session['user_id'];

                        /* Connecting to Local Database */
                        $this->_switchDB('local');

                    }


                    // Start Dependency Table logic
                    $this->_switchDB('local');

                    $sql = "SELECT * FROM chrysalis_tables WHERE is_active='1' AND is_dependency='Y'
                        GROUP BY dependency_order ORDER BY dependency_order,chrysalis_table_id ASC";
                    $tables = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();

                    foreach($tables as $k => $table)
                    {
                        $className = $table->class_name;

                        if($table->table_type == 'Insert') {

                            if(in_array($table->table_name, array('student_preferred_country')) ) {
                                $this->_switchDB('local');
                                $tb = $className::model()->findAllByAttributes(array('user_ref_id'=> $student->user_id));
                                foreach($tb as $k => $record) {
                                    $res = new $className('search');
                                    $res->attributes = $record->attributes;

                                    $this->_switchDB('prodDb');
                                    $primaryKey = $res->tableSchema->primaryKey;
                                    unset($res->$primaryKey);
                                    $res->user_ref_id = Yii::app()->session['user_id'];
                                    $res->no_scholarship = $record->no_scholarship;
                                    $res->save(false);

                                    $this->_switchDB('local');
                                    $childRecords = StudentPreferredLocation::model()->findAllByAttributes(array('preferred_country_ref_id'=> $record->preferred_country_id));
                                    if(count($childRecords)) {
                                        foreach($childRecords as $k => $childRecord) {
                                            $childRes = new StudentPreferredLocation('search');
                                            $childRes->attributes = $childRecord->attributes;

                                            $this->_switchDB('prodDb');
                                            $primaryKey = $childRes->tableSchema->primaryKey;
                                            unset($childRes->$primaryKey);
                                            $childRes->preferred_country_ref_id = $res->preferred_country_id;
                                            $childRes->save(false);
                                        }
                                    }
                                }
                            }
                            else if(in_array($table->table_name, array('umail_header')) ) {
                                $this->_switchDB('local');
                                $tb = $className::model()->findAllByAttributes(array('sender_id'=> $student->user_id));
                                foreach($tb as $k => $record) {
                                    $res = new $className('search');
                                    $res->attributes = $record->attributes;

                                    $this->_switchDB('prodDb');
                                    $primaryKey = $res->tableSchema->primaryKey;
                                    unset($res->$primaryKey);
                                    $res->sender_id = Yii::app()->session['user_id'];
                                    $res->save(false);

                                    $this->_switchDB('local');
                                    $childRecords = UmailMessage::model()->findAllByAttributes(array('header_ref_id'=> $record->header_id));
                                    if(count($childRecords)) {
                                        foreach($childRecords as $k => $childRecord) {
                                            $childRes = new UmailMessage('search');
                                            $childRes->attributes = $childRecord->attributes;

                                            $this->_switchDB('prodDb');
                                            $primaryKey = $childRes->tableSchema->primaryKey;
                                            unset($childRes->$primaryKey);
                                            $childRes->header_ref_id = $res->header_id;
                                            $childRes->save(false);
                                        }
                                    }
                                }
                            }
                            else if(in_array($table->table_name, array('user_entrance_exam')) ) {
                                $this->_switchDB('local');
                                $tb = $className::model()->findAllByAttributes(array('user_ref_id'=> $student->user_id),array('order'=>'user_entrance_exam_id ASC'));
                                foreach($tb as $k => $record) {
                                    $res = new $className('search');
                                    $res->attributes = $record->attributes;

                                    $this->_switchDB('prodDb');
                                    $primaryKey = $res->tableSchema->primaryKey;
                                    unset($res->$primaryKey);
                                    $res->user_ref_id = Yii::app()->session['user_id'];
                                    $res->added_by = Yii::app()->session['login_id'];
                                    $res->modified_by = Yii::app()->session['login_id'];
                                    $res->joined_coaching_inst = $record->joined_coaching_inst;
                                    $res->reappear_exam = $record->reappear_exam;
                                    $res->overall_marks = floatval(str_replace(',','', $record->overall_marks));
                                    $res->save(false);

                                    $this->_switchDB('local');
                                    $childRecords = UserEntranceExamModule::model()->findAllByAttributes(array('user_entrance_exam_ref_id'=> $record->user_entrance_exam_id));
                                    if(count($childRecords)) {
                                        foreach($childRecords as $k => $childRecord) {
                                            $childRes = new UserEntranceExamModule('search');
                                            $childRes->attributes = $childRecord->attributes;

                                            $this->_switchDB('prodDb');
                                            $primaryKey = $childRes->tableSchema->primaryKey;
                                            unset($childRes->$primaryKey);
                                            $childRes->user_entrance_exam_ref_id = $res->user_entrance_exam_id;
                                            $childRes->added_by = Yii::app()->session['login_id'];
                                            $childRes->modified_by = Yii::app()->session['login_id'];
                                            $childRes->save(false);
                                        }
                                    }
                                }
                            }
                            else if(in_array($table->table_name, array('student_education')) ) {
                                $this->_switchDB('local');
                                $tb = $className::model()->findAllByAttributes(array('user_ref_id'=> $student->user_id));
                                foreach($tb as $k => $record) {
                                    $res = new $className('search');
                                    $res->attributes = $record->attributes;

                                    $this->_switchDB('prodDb');
                                    $primaryKey = $res->tableSchema->primaryKey;
                                    unset($res->$primaryKey);
                                    $res->user_ref_id = Yii::app()->session['user_id'];
                                    $res->save(false);

                                    $this->_switchDB('local');
                                    $childRecords = StudentEducationDetail::model()->findAllByAttributes(array('student_education_ref_id'=> $record->student_education_id));
                                    if(count($childRecords)) {
                                        foreach($childRecords as $k => $childRecord) {
                                            $childRes = new StudentEducationDetail('search');
                                            $childRes->attributes = $childRecord->attributes;

                                            $this->_switchDB('prodDb');
                                            $primaryKey = $childRes->tableSchema->primaryKey;
                                            unset($childRes->$primaryKey);
                                            $childRes->student_education_ref_id = $res->student_education_id;
                                            $childRes->save(false);
                                        }
                                    }

                                    $this->_switchDB('local');
                                    $childRecords = StudentGradeCount::model()->findAllByAttributes(array('student_education_ref_id'=> $record->student_education_id));
                                    if(count($childRecords)) {
                                        foreach($childRecords as $k => $childRecord) {
                                            $childRes = new StudentGradeCount('search');
                                            $childRes->attributes = $childRecord->attributes;

                                            $this->_switchDB('prodDb');
                                            $primaryKey = $childRes->tableSchema->primaryKey;
                                            unset($childRes->$primaryKey);
                                            $childRes->student_education_ref_id = $res->student_education_id;
                                            $childRes->save(false);
                                        }
                                    }
                                }
                            }
                            else if(in_array($table->table_name, array('email_recipient')) ) {
                                $this->_switchDB('local');

                                $criteria = new CDbCriteria();
                                $criteria->join = 'INNER JOIN `email_message` em ON em.email_message_id = t.email_message_ref_id';
                                $criteria->condition = "to_email = :value";
                                $criteria->params = array(":value" => $student->username);
                                $message = EmailRecipient::model()->find($criteria);
                                $record = EmailMessage::model()->findByAttributes(array('email_message_id'=> $message->email_message_ref_id));

                                $res = new EmailMessage('search');
                                $res->attributes = $record->attributes;

                                $this->_switchDB('prodDb');
                                $primaryKey = $res->tableSchema->primaryKey;
                                unset($res->$primaryKey);
                                $res->save(false);

                                $this->_switchDB('local');
                                $childRecord = EmailRecipient::model()->findByAttributes(array('email_message_ref_id'=> $record->email_message_id));
                                $childRes = new EmailRecipient('search');
                                $childRes->attributes = $childRecord->attributes;

                                $this->_switchDB('prodDb');
                                $primaryKey = $childRes->tableSchema->primaryKey;
                                unset($childRes->$primaryKey);
                                $childRes->email_message_ref_id = $res->email_message_id;
                                $childRes->save(false);
                            }
                            else if(in_array($table->table_name, array('courses')) ) {
                                $this->_switchDB('local');
                                $sql = "SELECT spd.course_ref_id, preferred_department_id, spd.main_dept_ref_id,spd.sub_dept_ref_id FROM student_preferred_department spd LEFT JOIN courses c ON c.course_id = spd.course_ref_id
                                    WHERE user_ref_id = '".$student->user_id."' AND course_ref_id IS NOT NULL";
                                $courses = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
                                foreach($courses as $k => $record) {
                                    $courseRes = Courses::model()->findByAttributes(array('course_id'=> $record->course_ref_id));
                                    if($courseRes) {
                                        $res = new Courses('search');
                                        $res->attributes = $courseRes->attributes;

                                        $this->_switchDB('prodDb');
                                        $primaryKey = $res->tableSchema->primaryKey;
                                        unset($res->$primaryKey);
                                        $res->save(false);
                                        $childRecord = StudentPreferredDepartment::model()->findByAttributes(array('user_ref_id' => Yii::app()->session['user_id'], 'main_dept_ref_id'=> $record->main_dept_ref_id,'sub_dept_ref_id'=> $record->sub_dept_ref_id));
                                        if($res->course_id){
                                            $childRecord->course_ref_id = $res->course_id;
                                            $childRecord->save(false);
                                        }
                                    }
                                }
                            }
                            else if(in_array($table->table_name, array('student_career_plan_code')) ) {
                                $this->_switchDB('local');
                                $couponCode = StudentCareerPlanCode::model()->findByAttributes(array('user_ref_id'=> $student->user_id));
                                if($couponCode) {
                                    $this->_switchDB('prodDb');
                                    $couponCode = StudentCareerPlanCode::model()->findByAttributes(array('coupon_code'=> $couponCode->coupon_code));
                                    $couponCode->user_ref_id = Yii::app()->session['user_id'];
                                    $couponCode->used_on = $couponCode->used_on;
                                    $couponCode->band_ref_id = $couponCode->band_ref_id;
                                    $this->_switchDB('prodDb');
                                    $couponCode->save(false);
                                }
                            }
                            else if(in_array($table->table_name, array('lookup_school')) ) {
                                $this->_switchDB('local');
                                $sql = "SELECT user_id, school_name, user_entered, school_id FROM tbl_user_master um
                                        INNER JOIN lookup_school ls ON ls.school_id = um.school_ref_id
                                        WHERE user_id  = '".$student->user_id."' ";
                                $school = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
                                if($school->user_id) {
                                    $this->_switchDB('local');
                                    if($school->user_entered == '0') {
                                        $this->_switchDB('prodDb');
                                        $userTable = TblUserMaster::model()->findByAttributes(array('user_id'=> Yii::app()->session['user_id']));
                                        $userTable->school_ref_id = $school->school_id;
                                        $userTable->save(false);
                                    } else {
                                        $this->_switchDB('local');
                                        $schoolRecord = LookupSchool::model()->findByAttributes(array('school_id'=> $school->school_id));
                                        $res = new LookupSchool('search');
                                        $res->attributes = $schoolRecord->attributes;
                                        $this->_switchDB('prodDb');
                                        $primaryKey = $res->tableSchema->primaryKey;
                                        unset($res->$primaryKey);
                                        $res->save(false);
                                        $userTable = TblUserMaster::model()->findByAttributes(array('user_id'=> Yii::app()->session['user_id']));
                                        $userTable->school_ref_id = $res->school_id;
                                        $userTable->save(false);
                                    }
                                }
                            }
                            else if(in_array($table->table_name, array('student_shortlist_university')) ) {
                                $this->_switchDB('local');
                                $sql = "SELECT uni_id, user_ref_id, student_shortlist_university_id, is_user_entered FROM `student_shortlist_university` spu
                                        INNER JOIN tbl_university_master um ON um.uni_id = spu.uni_ref_id
                                    WHERE user_ref_id = '".$student->user_id."' ";
                                $universities = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
                                if($universities) {
                                    foreach($universities as $k => $record) {
                                        if($record->is_user_entered == '1') {
                                            $this->_switchDB('local');
                                            $uniData = TblUniversityMaster::model()->findByPk($record->uni_id);
                                            $universityRes = new TblUniversityMaster('search');
                                            $universityRes->attributes = $uniData->attributes;
                                            $universityRes->uni_name = $uniData->uni_name;
                                            $universityRes->added_by = Yii::app()->session['login_id'];
                                            $universityRes->modified_by = Yii::app()->session['login_id'];

                                            $this->_switchDB('prodDb');
                                            $primaryKey = $universityRes->tableSchema->primaryKey;
                                            unset($universityRes->$primaryKey);
                                            $universityRes->save(false);

                                            $this->_switchDB('local');
                                            $uniRes = StudentShortlistUniversity::model()->findByAttributes(array('student_shortlist_university_id'=> $record->student_shortlist_university_id,'uni_ref_id'=>$record->uni_id));
                                            if($uniRes) {
                                                $res = new StudentShortlistUniversity('search');
                                                $res->attributes = $uniRes->attributes;
                                                $res->uni_ref_id = $universityRes->uni_id;
                                                $res->user_ref_id = Yii::app()->session['user_id'];
                                                $res->added_by = Yii::app()->session['login_id'];
                                                $res->modified_by = Yii::app()->session['login_id'];
                                                $this->_switchDB('prodDb');
                                                $primaryKey = $res->tableSchema->primaryKey;
                                                unset($res->$primaryKey);
                                                $res->save(false);
                                            }
                                        }
                                        else
                                        {
                                            $this->_switchDB('local');
                                            $uniRes = StudentShortlistUniversity::model()->findByAttributes(array('student_shortlist_university_id'=> $record->student_shortlist_university_id,'uni_ref_id'=>$record->uni_id));
                                            if($uniRes) {
                                                $res = new StudentShortlistUniversity('search');
                                                $res->attributes = $uniRes->attributes;
                                                $res->user_ref_id = Yii::app()->session['user_id'];
                                                $res->added_by = Yii::app()->session['login_id'];
                                                $res->modified_by = Yii::app()->session['login_id'];
                                                $this->_switchDB('prodDb');
                                                $primaryKey = $res->tableSchema->primaryKey;
                                                unset($res->$primaryKey);
                                                $res->save(false);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }

                    $this->_switchDB('local');
                    // Update Local DB flag
                    $loginModel = LoginMaster::model()->findByAttributes(array('username'=> $student->username));
                    $loginModel->is_sync = '1';
                    $loginModel->save(false);

                    $this->_switchDB('prodDb');
                    // Update Production DB flag
                    $loginModel = LoginMaster::model()->findByAttributes(array('username'=> $student->username));
                    if($loginModel) {
                        $loginModel->is_sync = '1';
                        $loginModel->save(false);
                    }
                }
                $transaction->commit();
                echo '<br>'.$student->user_id.' - User updated successfully.<br>';
            }
            catch (Exception $exc) {
                $transaction->rollback();
                //echo $exc->getTraceAsString();
                echo $exc->getMessage();
            }
        }
    }

    public function actionChrysalisCode() {
        $version = Yii::app()->request->getParam('version');
        $exist = ChrysalisVersion::model()->findByAttributes(array('version'=> $version));
        if($exist) {
            $nextsequence = $exist->sequence_no+1;
            $versionData = ChrysalisVersion::model()->findByAttributes(array('sequence_no'=> $nextsequence));
            $nextVersion = $versionData->version;
            $myXMLData =
                "<?xml version='1.0' encoding='UTF-8'?>
			<unilocal>
				<version>$nextVersion</version>
				<phpcode>https://www.univariety.com/app/unilocal/phpcode.$nextVersion.zip</phpcode>
				<sqlcode>https://www.univariety.com/app/unilocal/sqlcode.$nextVersion.zip</sqlcode>
			</unilocal>";

            $xml = simplexml_load_string($myXMLData) or die("Error: Cannot create object");
            echo '<pre>'; print_r($xml); exit;
        }
        else {
            echo '<h1>This Version not Exist</h1>'; exit;
        }
    }
}
