<?php
define('SOLR_SERVER', '192.168.0.3');
define('SOLR_PORT', '8080');

require_once(dirname(__FILE__) . '/../components/helpers.php');
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');

// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
return array(

    'basePath' => dirname(__FILE__) . DIRECTORY_SEPARATOR . '..',
    'name' => 'Univariety',
    'language' => 'en',
    // preloading 'log' component
    'preload' => array('log'),

    // autoloading model and component classes
    'import' => require_once 'import_models_extensions.php',

    'modules' => require_once 'import_modules.php',

    'controllerMap' => array(
        'csstracking' => 'application.controllers.CssTrackingController',
        'min' => array(
            'class' => 'ext.minScript.controllers.ExtMinScriptController',
        ),
    ),
    
    // application components
    'components' => array(
        'facebook'=>array(
            'class' => 'ext.yii-facebook-opengraph.SFacebook',
            'appId'=>'143690485801383', // needed for JS SDK, Social Plugins and PHP SDK
            'secret'=>'18af17253c6a74a86d5cbe9ebba89651', // needed for the PHP SDK
        ),
        'mobileDetect' => array(
            'class' => 'ext.MobileDetect.MobileDetect'
        ),
        /*'geoip' => array(
            'class' => 'application.extensions.geoip.CGeoIP',
            // specify filename location for the corresponding database
            'filename' => dirname(__FILE__).'/../extensions/geoip/GeoLiteCity.dat',
            // Choose MEMORY_CACHE or STANDARD mode
            'mode' => 'STANDARD',
        ),
        'clientScript' => array(
            'class' => 'ext.minScript.components.ExtMinScript',
            'minScriptLmCache' => 86400 * 30,
        ),*/
        /*'clientScript' => array(
            'class' => 'application.extensions.yii-EClientScript.EClientScript',
            'combineScriptFiles' => !YII_DEBUG, // By default this is set to true, set this to true if you'd like to combine the script files
            'combineCssFiles' => !YII_DEBUG, // By default this is set to true, set this to true if you'd like to combine the css files
            'optimizeScriptFiles' => !YII_DEBUG, // @since: 1.1
            'optimizeCssFiles' => !YII_DEBUG, // @since: 1.1
            'optimizeInlineScript' => false, // @since: 1.6, This may case response slower
            'optimizeInlineCss' => false, // @since: 1.6, This may case response slower
        ),*/
        'image' => array(
            'class' => 'application.extensions.image.CImageComponent',
            // GD or ImageMagick
            'driver' => 'GD',
            // ImageMagick setup path
            'params' => array('directory' => '/opt/local/bin'),
        ),
        'session' => array(
            //'sessionName' => 'univarietySession',
            'autoStart' => true,
            'cookieParams' => array('domain' => DOMAIN),
        ),
        'mail' => array(
            'class' => 'ext.yii-mail.YiiMail',
            'viewPath' => 'application.views.mail',
            'logging' => true,
            'dryRun' => false
        ),
        'swiftMailer' => array(
            'class' => 'ext.swiftMailer.SwiftMailer',
        ),
        'metadata' => array('class' => 'Metadata'),

        // Enable Memcache
        //'cache' => require_once 'cache.php',
        'cache' =>  array(
            'class' => 'system.caching.CDummyCache',),

        'user' => array(
            // enable cookie-based authentication
            // 'lowAutoLogin' => true,
            'loginUrl' => array('/login'),
            'class' => 'RWebUser',
        ),
        'authManager' => array(
            'class' => 'RDbAuthManager',
            'connectionID' => 'db',
            'itemTable' => 'rbac_authitem',
            'itemChildTable' => 'rbac_authitemchild',
            'assignmentTable' => 'rbac_authassignment',
            'rightsTable' => 'rbac_rights',
            'defaultRoles' => array('Guest',),
        ),
        // uncomment the following to enable URLs in path-format

        'urlManager' => array(
            'class' => 'SeoManager',
            'urlFormat' => 'path',
            'rules' => require_once 'urlRules.php',
            'showScriptName' => false,
            'cacheID' => false,
        ),
        'assetManager'=>array(
            'class' => 'application.extensions.EAssetManager',
            'lessCompile'=>true,
            'lessCompiledPath'=>'themes/new_grid_theme/views/layouts/css',
            'lessFormatter'=>'compressed',
            'lessForceCompile'=>false,
        ),

        /* 'db'=>array(
            'connectionString' => 'sqlite:'.dirname(__FILE__).'/../data/testdrive.db',
        ),
        */
        'db' => array(
            'connectionString' => 'mysql:host=' . DBHOST . ';dbname=' . DBNAME,
            'emulatePrepare' => true,
            'username' => DBUSERNAME,
            'password' => DBPASSWORD,
            'charset' => 'utf8',
            'tablePrefix' => '',
            //'enableProfiling'=>true,
            'enableParamLogging' => false,
            'schemaCachingDuration' => 3600,
        ),

        'errorHandler' => array(
            // use 'site/error' action to display errors
            'errorAction' => 'site/error',
        ),
        'log' => array(
            'class' => 'CLogRouter',
            'routes' => array(
                array(
                    'class'=>'CFileLogRoute',
                    'logFile' => 'narnia.log',
                    'categories'=>'narnia.*',
                ),
                /*array(
                    'class' => 'CFileLogRoute',
                    'levels' => 'error, warning',
                ),
                //array(
                    //'class' => 'ext.slowquerylogger.SlowQueryLogRoute',
                    //'levels' => 'trace, profile',
                    //'logFile' => 'slowQueries.log',
                    //'slowQueryMin' => 1, // Minimum time for the query to be slow
                   // 'enableLogging' => true,
                    //'showOnWebPage' => true,
                //),
                // uncomment the following to show log messages on web pages
                */

              
               
               /*array(
                    'class' => 'CWebLogRoute',
                ),*/

                
            ),
        ),
        'assetManager'=>array(
            'class' => 'application.extensions.EAssetManager',
            'lessCompile'=>true,
            'lessCompiledPath'=>'themes/new_grid_theme/views/layouts/css',
            'lessFormatter'=>'compressed',
            'lessForceCompile'=>false,
        ),

        //'assetManager'=>array('basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..'.DIRECTORY_SEPARATOR.'..'.DIRECTORY_SEPARATOR.'assets',),
    ),

    // application-level parameters that can be accessed
    // using Yii::app()->params['paramName']
    'params' => require_once 'params.php',

);
