<?php

class ValidateMarks extends CComponent {

    public $userId = null;

    //condition values equals100 or above95 or diff or others or get_marks_above_95
    public function ValidateMarks($condition = 'equals100') {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $criteria = new CDbCriteria;
        $criteria->select = 't.overall_marks, t.student_education_id, t.board_ref_id';
        $criteria->condition = " user_ref_id = ".$this->userId." AND t.class_level = '10' ";
        $criteria->with = array(
            'boardRef'=>array('select'=>'boardRef.board_ref_id', 'joinType'=>'INNER JOIN'),
        );
        $class10result = StudentEducation::model()->find($criteria);
        $marks_10 = $class10result->overall_marks;
        if (in_array($class10result->boardRef->board_ref_id, array(5, 6, 8)) || $class10result->boardRef->board_ref_id > 8) {
            $marks_10 = $this->convertOverAllMarks($class10result->boardRef->board_ref_id, $class10result->overall_marks, $class10result->student_education_id,$class10result->board_ref_id);
        }

        if (($class10result->boardRef->board_ref_id == 1) || ($class10result->boardRef->board_ref_id == 7)) {
            if (($class10result->overall_marks) > 0 && ($class10result->overall_marks <= 10)) {
                $marks = ($class10result->overall_marks*9.5);
                $marks = round($marks, 0);
                $marks_10 = $marks;
            }
        }

        $criteria = new CDbCriteria;
        $criteria->select = 't.overall_marks, t.student_education_id, t.board_ref_id';
        $criteria->condition = " user_ref_id = ".$this->userId." AND t.class_level = '12' ";
        $criteria->with = array(
            'boardRef'=>array('select'=>'boardRef.board_ref_id', 'joinType'=>'INNER JOIN'),
            'boardRef.boardRef'=>array('select'=>'boardRef.board_name', 'alias'=>'lp', 'joinType'=>'INNER JOIN'),
        );
        $class12result = StudentEducation::model()->find($criteria);
        $marks_12 = $class12result->overall_marks;
        if (in_array($class12result->boardRef->board_ref_id, array(5, 6, 8)) || $class12result->boardRef->board_ref_id > 8 ) {
            $marks_12 = $this->convertOverAllMarks($class12result->boardRef->board_ref_id, $class12result->overall_marks, $class12result->student_education_id, $class12result->board_ref_id);
        }

        if ($class12result->boardRef->board_ref_id == 7) {
            if (($class12result->overall_marks) > 0 && ($class12result->overall_marks <= 10)) {
                $marks = ($class12result->overall_marks*9.5);
                $marks = round($marks, 0);
                $marks_12 = $marks;
            }
        }

        switch ($condition) {
            case 'equals100':
                return (((int)$marks_10 == (int)$marks_12) && ((int)$marks_12 == 100)) ? 0 : 1;
                break;
            case 'above95':
                return ((int)$marks_10 == (int)$marks_12 && in_array((int)$marks_10, array(96, 97, 98, 99))) ? 0 : 1;
                break;
            case 'diff':
                $diff = (int)$marks_10 - (int)$marks_12;
                return ($diff >= -15 && $diff <= 15) ? 1 : 0;
                break;
            case 'others':
                return array('10'=>($marks_10 + 0), '12'=>($marks_12 + 0), '10b'=>$class10result->boardRef->board_ref_id, '12b'=>$class12result->boardRef->board_ref_id, '10b_name'=>$class10result->boardRef->boardRef->board_name, '12b_name' =>$class12result->boardRef->boardRef->board_name);
                break;
            case 'get_marks_above_95':
                return ((int)$marks_10 == (int)$marks_12 && !in_array((int)$marks_10, array(96, 97, 98, 99))) ? 0 : (int)$marks_10;
                break;
        }
    }

    public function validateSubjectMarks10() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }
        $marks_10 = 0;

        $sData = StudentEducation::model()->with('studentEducationDetails')->find("class_level =  '10' AND user_ref_id='{$this->userId}'");
        if($sData == null) return 0;

        $boardId   = $sData->boardRef->board_ref_id;

        if(count($sData->studentEducationDetails)){
            foreach($sData->studentEducationDetails as $key => $value) {
                $subjectMarks = 0;
                if(in_array($boardId, array('5', '7', '8'))){
                    $sGrade = LookupGrade::model()->findByAttributes(array('grade_id' => $value->grade_ref_id), array('limit' => '1'));
                    $grade = $sGrade ? $sGrade->grade_type : 0;
                    $subjectMarks = $this->convertSubjectMarks($boardId, $grade, $sData->board_ref_id);
                    /*if ($boardId == 8) {
                        if ($subjectMarks == 99) {
                            $subjectMarks = 100;
                        }
                    } elseif (($boardId == 5) || ($boardId == 7)) {
                        if ($subjectMarks == 90) {
                            $subjectMarks = 100;
                        }
                    }*/
                } else {
                    if ($boardId == 6) {
                        $subjectMarks = $this->convertSubjectMarks($boardId, $value->marks, $sData->board_ref_id);
                        /*if ($subjectMarks == 98) {
                            $subjectMarks = 100;
                        }*/
                    } else {
                        $subjectMarks = $value->marks;
                    }
                }
                if ($subjectMarks == 100) {
                    $marks_10++;
                }
            }
        }


        return ($marks_10 > 1) ? 0 : 1;

    }

    public function validateSubjectMarks12() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }
        $marks_12 = 0;

        $sData = StudentEducation::model()->with('studentEducationDetails')->find("class_level =  '12' AND user_ref_id='{$this->userId}'");
        if($sData == null) return 0;

        $boardId   = $sData->boardRef->board_ref_id;

        if(count($sData->studentEducationDetails)){
            foreach($sData->studentEducationDetails as $key => $value) {
                $subjectMarks = 0;
                if(in_array($boardId, array('5', '7', '8'))){
                    $sGrade = LookupGrade::model()->findByAttributes(array('grade_id' => $value->grade_ref_id), array('limit' => '1'));
                    $grade = $sGrade ? $sGrade->grade_type : 0;
                    $subjectMarks = $this->convertSubjectMarks($boardId, $grade, $sData->board_ref_id);
                    /*if ($boardId == 8) {
                        if ($subjectMarks == 99) {
                            $subjectMarks = 100;
                        }
                    } elseif (($boardId == 5) || ($boardId == 7)) {
                        if ($subjectMarks == 90) {
                            $subjectMarks = 100;
                        }
                    }*/
                } else {
                    if ($boardId == 6) {
                        $subjectMarks = $this->convertSubjectMarks($boardId, $value->marks, $sData->board_ref_id);
                       /* if ($subjectMarks == 98) {
                            $subjectMarks = 100;
                        }*/
                    } else {
                        $subjectMarks = $value->marks;
                    }
                }

                if ($subjectMarks == 100) {
                    $marks_12++;
                }
            }
        }

        return ($marks_12 > 1) ? 0 : 1;

    }

    private function convertOverAllMarks($board, $marks, $se_id, $board_e_id) {
        $overall = 0;
        switch ($board) {
            case 5:
                $sOverAll = StudentGradeCount::model()->findAll("student_education_ref_id ='{$se_id}' AND grade_count > 0");
                if($sOverAll){
                    $gradesList = array();
                    foreach($sOverAll as $OverAll){
                        $aOverAll[] = $OverAll->grade_count.'-'.$OverAll->board_conversion_ref_id;
                    }
                }

                if(count($aOverAll)){
                    $gradeCnt = 0;
                    foreach($aOverAll as $OverAllMarks){
                        list($count, $grade) = explode("-", $OverAllMarks);
                        $gradeCnt += $count;
                        $gradesLst[$grade] = $count;
                        if($gradeCnt > 3) {
                            while($gradesLst[$grade]--){
                                if(array_sum($gradesLst) == '3')
                                    break;
                            }
                            break;
                        }
                    }
                }

                if(count($gradesLst)){
                    $OverallMarks = 0;
                    foreach($gradesLst as $grade => $count){
                        $sData = LookupBoardConversion::model()->findByPk($grade);
                        $OverallMarks += $sData ? $sData->convert_marks * $count : 0;
                    }
                    $overall = round($OverallMarks/array_sum($gradesLst), 2);
                }
                break;
            case 6:
                $sData = LookupBoardConversion::model()->findByAttributes(array('board_equivalent_ref_id' => $board_e_id, 'mark_type' => 'o', 'board_marks' => (int)$marks), array('limit' => '1'));
                $overall = $sData ? $sData->convert_marks : 0;
                break;
            case 8:
                if($marks <= 4.4 ){
                    $sData = LookupBoardConversion::model()->findByAttributes(array('board_ref_id' => '8', 'mark_type' => 'o', 'board_marks' => (float) number_format($marks, 1)), array('limit' => '1'));
                    $overall = $sData ? $sData->convert_marks : 0;
                }else{
                    $overall = $marks;
                }
                break;
                default:
                    if ($board > 8) {
                        $sData = LookupBoardConversion::model()->findByAttributes(array('board_equivalent_ref_id' => $board_e_id, 'mark_type' => 'OS', 'board_marks' => (int)$marks), array('limit' => '1'));
                        $sData->convert_marks = ($sData->convert_marks > 100) ? 100: $sData->convert_marks;
                        $overall = $sData ? $sData->convert_marks : 0;
                    }
        }

        return (int)$overall;
    }

    private function convertSubjectMarks($board, $marks, $board_e_id) {
        switch ($board) {
            case 6:
                $sData = LookupBoardConversion::model()->findByAttributes(array('board_equivalent_ref_id' => $board_e_id, 'mark_type' => 'S', 'board_marks' => (int)$marks), array('limit' => '1'));
                return $sData ? $sData->convert_marks : 0;
                break;
            case 5:
                $sData = LookupBoardConversion::model()->findByAttributes(array('board_equivalent_ref_id' => $board_e_id, 'mark_type' => 'OS', 'board_marks' => $marks), array('limit' => '1'));
                return $sData ? $sData->convert_marks : 0;
                break;
            case 7:
                $sData = LookupBoardConversion::model()->findByAttributes(array('board_equivalent_ref_id' => $board_e_id, 'mark_type' => 'S', 'board_marks' => $marks), array('limit' => '1'));
                return $sData ? $sData->convert_marks : 0;
                break;
            case 8:
                $sData = LookupBoardConversion::model()->findByAttributes(array('board_equivalent_ref_id' => $board_e_id, 'mark_type' => 'S', 'board_marks' => $marks), array('limit' => '1'));
                return $sData ? $sData->convert_marks : 0;
                break;
        }
    }
}