<?php

class UniversityEntryRequirements extends CComponent {

    private $universityid;

    private $departmentid;

    private $masterweightage;

    private $academicoverall;

    private $academicsubjects = array();

    private $standardtests  = array();

    public function setUniversityID($universityid){

        $this->universityid = $universityid;
    }

    public function getUniversityID(){

        return $this->universityid;
    }

    public function setDepartmentID($departmentid){

        $this->departmentid = $departmentid;
    }

    public function getDepartmentID(){

        return $this->departmentid;
    }

    public function setMasterWeightage($masterWeightage){

        if(is_object($masterWeightage))
            $this->masterweightage = $masterWeightage;
    }

    public function getMasterWeightage(){

         return $this->masterweightage;
    }

    public function setAcademicOverall($academicoverall){

        if(is_object($academicoverall) && $academicoverall->weightage && $academicoverall->minrange)
            $this->academicoverall = $academicoverall;
    }

    public function getAcademicOverall(){

        return $this->academicoverall;
    }

    public function setAcademicSubject($oAcademicSubject){

        if(is_object($oAcademicSubject) && $oAcademicSubject->weightage && $oAcademicSubject->minrange)
            $this->academicsubjects[$oAcademicSubject->subjectName] = $oAcademicSubject;
    }

    public function getAcademicSubjects(){

        return $this->academicsubjects;
    }

    public function getAcademicSubjectObject($subjectName){

        return isset($this->academicsubjects[$subjectName]) ? $this->academicsubjects[$subjectName] : false ;
    }

    public function unsetAcademicSubjectObject($subjectName){

        if(isset($this->academicsubjects[$subjectName])) {
            unset($this->academicsubjects[$subjectName]);
        }
    }

    public function getHighestWeightageSubjects(){

        $subjects = array();
        if(count($this->getAcademicSubjects())){

            foreach($this->getAcademicSubjects() as $subjectName => $objSubject){
                $subjects[$subjectName] = $objSubject->weightage;
            }
            arsort($subjects);
            $subjects = array_slice($subjects, 0, 2);
        }

        return count($subjects) ? $subjects : false;
    }

    public function getAcademicSubjectsCount() {

        return count($this->getAcademicSubjects());
    }

    public function getAcademicWeightagesSum(){

        // overall weightage
        $WeightagesSum = $this->academicoverall->weightage;

        // subjects weightage
        foreach ($this->getAcademicSubjects() as $subjectName => $subjectObj) {
            $WeightagesSum += $subjectObj->weightage;
        }
        return $WeightagesSum;
    }

    public function getMasterWeightagesSum(){

        return ($this->masterweightage->academicsweightage + $this->masterweightage->standardsweightage + $this->masterweightage->workexperienceweightage + $this->masterweightage->extracuricullarweightage);

    }

    public function getHighestWeightageSectionsInTest($testName){

        $sections = array();
        $testSections = $this->getSectionsByStandardTest($testName);
        if($testSections && count($testSections)){

            foreach($testSections as $sectionName => $sectionObj){
                $sections[$sectionName] = $sectionObj->weightage;
            }
            arsort($sections);
            $sections = array_slice($sections, 0, 2);
        }

        return count($sections) ? $sections : false;
    }

    public function getSectionWeightagesSumByTest($testName){

        $testObj = $this->getStandardTestObject($testName);

        // test overall weightage
        $WeightagesSum = $testObj->standardTestOverAll->weightage;

        // sections weightage
        foreach ($this->getSectionsByStandardTest($testName) as $sectionName => $sectionObj) {
            $WeightagesSum += $sectionObj->weightage;
        }
        return $WeightagesSum;
    }

    public function setStandardTest($oStandardTest){

        if(is_object($oStandardTest) && is_object($oStandardTest->standardTestOverAll))
            $this->standardtests[$oStandardTest->standardTestName] = $oStandardTest;
    }

    public function getStandardTests(){

        return $this->standardtests;
    }

    public function getStandardTestObject($testName){

        return isset($this->standardtests[$testName]) ? $this->standardtests[$testName] : false ;
    }

    public function getOverAllByStandardTest($testName){

        return isset($this->standardtests[$testName]) ? $this->standardtests[$testName]->standardTestOverAll : false ;
    }

    public function getSectionsByStandardTest($testName){

        return isset($this->standardtests[$testName]) ? $this->standardtests[$testName]->standardTestSections : false ;
    }

    public function isQualifierTest($testName = ''){

        $aQualifierTests = array("IELTS", "TOEFL");

        return in_array($testName, $aQualifierTests);
    }

    public function unsetStandardTestObject($testName){

        if(isset($this->standardtests[$testName])) {
            unset($this->standardtests[$testName]);
        }
    }

    public function unsetSectionsByTest($testName, $sectionName = ''){

        if(isset($this->standardtests[$testName])) {
            if($sectionName)
                unset($this->standardtests[$testName]->standardTestSections[$sectionName]);
            else
                $this->standardtests[$testName]->standardTestSections = array();
        }
    }

    public function getStandardTestSectionObject($testName, $sectionName){

        return isset($this->standardtests[$testName]->standardTestSections[$sectionName]) ? $this->standardtests[$testName]->standardTestSections[$sectionName] : false ;
    }

}
