<?php
Yii::import('application.components.admissionchances.settersngetters.*');
Yii::import('application.components.admissionchances.AdmissionChancesEngine');

class TestDriver extends CComponent {

    private $universityID   = null;
    private $studentID      = null;
    private $departmentID   = null;
    private $countryID      = null;

    private $universityObj   = null;
    private $studentObj      = null;
    private $sortOrder       = SORT_DESC;
    private $objStdMarks    = null;


    public function setDepartmentID($departmentID){
        $this->departmentID = $departmentID;
    }

    public function setUniversityID($universityID){
        $this->universityID = $universityID;
    }

    public function setStudentID($studentID){
        $this->studentID = $studentID;
    }

    public function setCountryID($countryID){
        $this->countryID = $countryID;
    }

    public function setUniversityObj($universityObj){
        $this->universityObj = $universityObj;
    }

    public function setStudentObj($studentObj){
        $this->studentObj = $studentObj;
    }

    public function setSortOrder($sortOrder){
        $this->sortOrder = $sortOrder;
    }

    public function calculateAdmissionScore(){

        $model = UserUniversityAdmissionScore::model()->findByAttributes(array(
            'user_ref_id' => $this->studentID,
            'uni_ref_id' => $this->universityID,
            'dept_ref_id' => $this->departmentID,
        ));

        if($model){
            $chanceScore      = $model->admission_score;
        }else{

            $objUnvEntryRqts  = $this->_getUnvEntryRqtsObject();
            $objStdMarks = $this->objStdMarks;

            if(!$objStdMarks) {
                $objStdMarks  = $this->_getStdMarksObject();
                $this->objStdMarks = $objStdMarks;
            }

            $objChances       = new AdmissionChancesEngine($objUnvEntryRqts, $objStdMarks);
            $chanceScore      = $objChances->getAdmissionChances();

            if(!is_null($this->studentID) && is_numeric($chanceScore)){

                $Sql = "DELETE FROM user_university_admission_score WHERE user_ref_id = {$this->studentID} AND uni_ref_id={$this->universityID} AND dept_ref_id={$this->departmentID}";
                Yii::app()->db->createCommand($Sql)->execute();

                // save the result
                $model = new UserUniversityAdmissionScore;
                $model->setAttributes(array(
                    'user_ref_id' => $this->studentID,
                    'uni_ref_id' => $this->universityID,
                    'dept_ref_id' => $this->departmentID,
                    'admission_score' => $chanceScore,
                    'added_on' => date('Y-m-d H:i:s'),
                ));
                $model->save();
            }
        }
        return $chanceScore;
    }

    public function getAdmissionChances(){


        if(is_null($this->universityID) && is_null($this->universityObj) && $this->countryID){

            $aChances = array();
            $Universities = $this->_getUniversitiesWithDepartmentByCountry();
            if($Universities) {
                foreach($Universities as $aUniversity){

                    $this->universityID = $aUniversity['uni_id'];
                    $chanceScore = $this->calculateAdmissionScore();

                    $aChances[]     = array('countryID' => $this->countryID, 'universityID' => $this->universityID, 'departmentID'=> $this->departmentID, 'score' => $chanceScore);

                }
            }
            $this->_sortResultByScore($aChances, 'score');
            return json_encode($aChances);

        }else{

            $chanceScore = $this->calculateAdmissionScore();

            return json_encode(
                array('countryID' => $this->countryID, 'universityID' => $this->universityID, 'departmentID'=> $this->departmentID, 'score' => $chanceScore)
            );
        }
    }

    private function _getUnvEntryRqts(){

        // fetch, form univ object and return it.
        $sData = UniversityDepartmentMasterWeightage::model()->find("uni_ref_id =  '{$this->universityID}' AND main_department_ref_id='{$this->departmentID}'");
        if($sData == null) return;

        $objUniEntryRqts = new UniversityEntryRequirements();
        $objUniEntryRqts->universityid = $this->universityID;
        $objUniEntryRqts->departmentid = $this->departmentID;

        // create master weightage obj
        $objMstrWtge = new UniversirtyMasterWeightage();
        $objMstrWtge->academicsweightage = $sData->academics_weightage;
        $objMstrWtge->standardsweightage = $sData->std_test_weightage;
        $objMstrWtge->workexperienceweightage = $sData->work_experience_weightage;
        $objMstrWtge->extracuricullarweightage = $sData->extra_curricular_weightage;
        // assign master weightage pbj
        $objUniEntryRqts->masterweightage = $objMstrWtge;

        $sData = UniversityDepartmentOverallCutoff::model()->find("uni_ref_id =  '{$this->universityID}' AND department_ref_id='{$this->departmentID}'");
        if($sData == null) return;

        // create academic overall obj
        $objAcdmcOverall = new UniversityAcademicOverAll();
        $objAcdmcOverall->weightage = $sData->weightage;
        $objAcdmcOverall->minrange  = $sData->min_cutoff;
        $objAcdmcOverall->tolerance = $sData->tolerance;
        $objAcdmcOverall->highrange = $sData->upper_range;
        // assign academic overall obj
        $objUniEntryRqts->academicoverall = $objAcdmcOverall;

        $sData = DepartmentSubject::model()->with('universityDepartmentSubjectCutoffs')->findAll("department_ref_id ='{$this->departmentID}' AND universityDepartmentSubjectCutoffs.uni_ref_id='{$this->universityID}'");
        if($sData){
            foreach($sData as $objData) {

                // create academic subject obj
                $objAcdmcSubject = new UniversityAcademicSubject();
                $objAcdmcSubject->subjectName = $objData->subjectRef->subject_name;
                foreach($objData->universityDepartmentSubjectCutoffs as $key => $value) {
                    $objAcdmcSubject->weightage = $value->weightage;
                    $objAcdmcSubject->minrange  = $value->min_cutoff;
                    $objAcdmcSubject->tolerance = $value->tolerance;
                    $objAcdmcSubject->highrange = $value->upper_range;
                }
                // assign academic subject obj
                $objUniEntryRqts->academicsubject = $objAcdmcSubject;
            }
        }

        $sData = DepartmentEntranceExam::model()->with('universityDepartmentEntranceExamOverallCutoffs')->findAll("country_ref_id ='{$this->countryID}' AND department_ref_id='{$this->departmentID}' AND universityDepartmentEntranceExamOverallCutoffs.uni_ref_id='{$this->universityID}'");

        if($sData){

            foreach($sData as $objData) {

                // create test obj
                $objStandardTest = new UniversityStandardTest();
                $objStandardTest->standardTestName = $objData->entranceExamRef->entrance_short_name;
                foreach($objData->universityDepartmentEntranceExamOverallCutoffs as $key => $value) {

                    // create test overall obj
                    $objStandardOverall = new UniversityStandardTestOverAll();
                    $objStandardOverall->weightage = $value->weightage;
                    $objStandardOverall->minrange  = $value->min_cutoff;
                    $objStandardOverall->tolerance = $value->low_range;
                    $objStandardOverall->highrange = $value->upper_range;

                    // assign test overall obj
                    $objStandardTest->standardTestOverAll = $objStandardOverall;
                }


                $sql ="SELECT eem.module_name, udeemc.* FROM entrance_exam_module eem
               INNER JOIN entrance_exam_module_entrance_exam eemee ON eemee.entrance_exam_module_ref_id = eem.entrance_exam_module_id
               INNER JOIN entrance_exam_module_department eemd ON eemd.entrance_exam_module_entrance_exam_ref_id = eemee.entrance_exam_module_entrance_exam_id
               INNER JOIN university_department_entrance_exam_module_cutoff udeemc ON udeemc.entrance_exam_module_department_ref_id =eemd.entrance_exam_module_department_id WHERE udeemc.uni_ref_id = :universityid AND eemd.department_ref_id= :departmentid AND eemee.entrance_exam_ref_id= :entranceexamid";
                $command =Yii::app()->db->createCommand($sql);

                $command->bindValue(":universityid", $this->universityID, PDO::PARAM_INT);
                $command->bindValue(":departmentid", $this->departmentID, PDO::PARAM_INT);
                $command->bindValue(":entranceexamid", $objData->entrance_exam_ref_id, PDO::PARAM_INT);
                $res =$command->queryAll();

                if($res){
                    foreach($res as $row){
                        // create section object
                        $objStandardSection = new UniversityStandardTestSection();
                        $objStandardSection->sectionName = $row['module_name'];
                        $objStandardSection->weightage = $row['weightage'];
                        $objStandardSection->minrange  = $row['min_cutoff'];
                        $objStandardSection->tolerance = $row['low_range'];
                        $objStandardSection->highrange = $row['upper_range'];
                        // assign section object
                        $objStandardTest->standardTestSection = $objStandardSection;

                    }
                }
                // Assign Standard Test Info
                $objUniEntryRqts->standardtest = $objStandardTest;
            }
        }

        return $objUniEntryRqts;
    }


    private function _getUnvEntryRqtsObject(){

        if(is_object($this->universityObj))
            return $this->universityObj;

        // This object does not change for a given univ and department and putting into a cache
        $uniq_key = $this->universityID.'-'.$this->departmentID;
        if(!Yii::app()->cache->get($uniq_key)){
            $unvEntryReqts = $this->_getUnvEntryRqts();
            Yii::app()->cache->set($uniq_key, $unvEntryReqts, 24*60*60*30); // 1 month

        }
        return Yii::app()->cache->get($uniq_key);
    }

    public function _getStdMarksObject(){

        if(is_object($this->studentObj))
            return $this->_convertStudentMarks($this->studentObj);

        $sData = StudentEducation::model()->with('studentEducationDetails')->find("class_level =  '12' AND user_ref_id='{$this->studentID}'");
        if($sData == null) return;

        $objStudentMarks = new StudentMarks();
        $objStudentMarks->studentboardid   = $sData->boardRef->board_ref_id;

        if(in_array($objStudentMarks->studentboardid, array('5'))){
            // CIE board // CBSE - I (7) board (May be change later)

            // overall
            $sOverAll = StudentGradeCount::model()->findAll("student_education_ref_id ='{$sData->student_education_id}' AND grade_count > 0");
            if($sOverAll){
                $gradesList = array();
                foreach($sOverAll as $OverAll){
                    $conversion = LookupBoardConversion::model()->findByPk($OverAll->board_conversion_ref_id);
                    $gradesList[] = $OverAll->grade_count.'-'.$conversion->board_marks;
                }
                $objStudentMarks->overall = count($gradesList) ? implode("$|$", $gradesList) : 0;
            }else
                $objStudentMarks->overall = 0;
        }else{

            if(!(int)$sData->overall_marks) { return; }
            $objStudentMarks->overall   = $sData->overall_marks;
        }

        // subjects
        if(count($sData->studentEducationDetails)){
            foreach($sData->studentEducationDetails as $key => $value) {
                // create subject obj
                $objSubject = new StudentSubject();
                $objSubject->subjectName  = $value->studentSubjectRef->subjectMasterRef->subject_name;

                if(in_array($objStudentMarks->studentboardid, array('5', '7', '8'))){
                    $sGrade = LookupBoardConversion::model()->findByPk($value->board_conversion_ref_id);
                    $objSubject->subjectMarks = $sGrade ? $sGrade->board_marks : 0;
                }else{
                    $objSubject->subjectMarks = $value->marks;
                }

                // Assign  Subject obj
                $objStudentMarks->subject = $objSubject;
            }
        }


        $sData = UserEntranceExam::model()->with('userEntranceExamModules')->findAll("user_ref_id='{$this->studentID}' AND exam_status='Completed' AND overall_marks > 0");
        if($sData){

            foreach($sData as $objData){

                // create Standard Test obj
                $objTest = new StudentStandardTest();
                $objTest->standardTestName = $objData->entranceExamRef->entrance_short_name;
                $objTest->standardTestOverAllMarks = $objData->overall_marks;

                foreach($objData->userEntranceExamModules as $key => $value){

                    // create section obj
                    $objTestSection = new StudentStandardTestSection();
                    $objTestSection->sectionName  = $value->entranceExamModuleEntranceExamRef->entranceExamModuleRef->module_name;
                    $objTestSection->sectionMarks = $value->marks;
                    // Assign section obj
                    $objTest->standardTestSection = $objTestSection;
                }
                // Assign Standard Test Info
                $objStudentMarks->standardtest = $objTest;
            }
        }

        return $this->_convertStudentMarks($objStudentMarks);
    }

    private function _convertStudentMarks($objStudentMarks)
    {

        if(!is_object($objStudentMarks)) return;

        $objStudentMarks = clone $objStudentMarks;
        $boardID = $objStudentMarks->studentboardid;
        $board_det = LookupBoardEquivalent::model()->findByAttributes(array('board_ref_id' => $boardID, 'class_level' => '12'), array('limit' => '1'));
        if($boardID){
            switch($boardID){
                case "6" : // IB board

                    // for overall
                    $sData = LookupBoardConversion::model()->findByAttributes(array('board_equivalent_ref_id' => '12', 'mark_type' => 'o', 'board_marks' => (int)$objStudentMarks->overall), array('limit' => '1'));
                    $objStudentMarks->overall = $sData ? $sData->convert_marks : 0;

                    // for subjects
                    if(count($objStudentMarks->subjects)){
                        foreach($objStudentMarks->subjects as $subjectName => $subjectObj){
                            $sData = LookupBoardConversion::model()->findByAttributes(array('board_equivalent_ref_id' => '12', 'mark_type' => 's', 'board_marks' => (int)$subjectObj->subjectMarks), array('limit' => '1'));
                            $objStudentMarks->subjects[$subjectName]->subjectMarks = $sData ? $sData->convert_marks : 0;
                        }
                    }

                    break;

                case "8" : // American Curriculum board

                    // for overall
                    if($objStudentMarks->overall <= 4.4 ){
                        $sData = LookupBoardConversion::model()->findByAttributes(array('board_ref_id' => '8', 'mark_type' => 'o', 'board_marks' => (float) number_format($objStudentMarks->overall, 1)), array('limit' => '1'));
                        $objStudentMarks->overall = $sData ? $sData->convert_marks : 0;
                    }else{
                        //$objStudentMarks->overall = 0;
                    }

                    // for subjects
                    if(count($objStudentMarks->subjects)){
                        foreach($objStudentMarks->subjects as $subjectName => $subjectObj){
                            $sData = LookupBoardConversion::model()->findByAttributes(array('board_ref_id' => '8', 'mark_type' => 's', 'board_marks' => $subjectObj->subjectMarks), array('limit' => '1'));
                            $objStudentMarks->subjects[$subjectName]->subjectMarks = $sData ? $sData->convert_marks : 0;
                        }
                    }
                    break;

                case "5" : // CIE board
                    // for overall
                    $aOverAll = $objStudentMarks->overall ? explode('$|$', $objStudentMarks->overall) : array();

                    $gradesLst = array();
                    if(count($aOverAll)){
                        $gradeCnt = 0;
                        foreach($aOverAll as $OverAllMarks){
                            list($count, $grade) = explode("-", $OverAllMarks);
                            $gradeCnt += $count;
                            $gradesLst[$grade] = $count;
                            if($gradeCnt > 3) {
                                while($gradesLst[$grade]--){
                                    if(array_sum($gradesLst) == '3')
                                        break;
                                }
                                break;
                            }
                        }
                    }

                    if(count($gradesLst)){
                        $OverallMarks = 0;
                        foreach($gradesLst as $grade => $count){
                            $sData = LookupBoardConversion::model()->findByAttributes(array('board_equivalent_ref_id' => '10', 'mark_type' => 'os', 'board_marks' => $grade), array('limit' => '1'));
                            $OverallMarks += $sData ? $sData->convert_marks * $count : 0;
                        }
                        $objStudentMarks->overall = round($OverallMarks/array_sum($gradesLst), 2);
                    }else{
                        $objStudentMarks->overall = 0;
                    }

                    // for subjects
                    if(count($objStudentMarks->subjects)){
                        foreach($objStudentMarks->subjects as $subjectName => $subjectObj){
                            $sData = LookupBoardConversion::model()->findByAttributes(array('board_equivalent_ref_id' => '10', 'mark_type' => 'os', 'board_marks' => $subjectObj->subjectMarks), array('limit' => '1'));
                            $objStudentMarks->subjects[$subjectName]->subjectMarks = $sData ? $sData->convert_marks : 0;
                        }
                    }

                    break;
                case "7" : // CBSE - I board (May be change later)
                    if (($objStudentMarks->overall) > 0 && ($objStudentMarks->overall <= 10)) {
                        $marks = ($objStudentMarks->overall*9.5);
                        $marks = round($marks, 0);
                        $objStudentMarks->overall = $marks;
                    }

                    // for subjects
                    if(count($objStudentMarks->subjects)){
                        foreach($objStudentMarks->subjects as $subjectName => $subjectObj){
                            $sData = LookupBoardConversion::model()->findByAttributes(array('board_equivalent_ref_id' => '20', 'mark_type' => 's', 'board_marks' => $subjectObj->subjectMarks), array('limit' => '1'));
                            $objStudentMarks->subjects[$subjectName]->subjectMarks = $sData ? $sData->convert_marks : 0;
                        }
                    }
                    break;

                default:

                if($boardID > 8){ // For state Boards

                    // for overall
                    $sData = LookupBoardConversion::model()->findByAttributes(array('board_equivalent_ref_id' => $board_det->board_equivalent_id, 'mark_type' => 'OS', 'board_marks' => (int)$objStudentMarks->overall), array('limit' => '1'));
                    $objStudentMarks->overall = $sData ? ($objStudentMarks->overall > 100 ? 100 : $sData->convert_marks) : 0;

                    // for subjects
                    if(count($objStudentMarks->subjects)){
                        foreach($objStudentMarks->subjects as $subjectName => $subjectObj){
                            $sData = LookupBoardConversion::model()->findByAttributes(array('board_equivalent_ref_id' => $board_det->board_equivalent_id, 'mark_type' => 'OS', 'board_marks' => $subjectObj->subjectMarks+0), array('limit' => '1'));
                            $objStudentMarks->subjects[$subjectName]->subjectMarks = $sData ? ($sData->convert_marks > 100 ? 100 : $sData->convert_marks) : 0;
                        }
                    }
                }
            }
        }

        if(!is_null($this->studentID)){
            // store overall in percent
            $Sql = "SELECT overall_12 FROM student_overall_percent WHERE student_ref_id='".$this->studentID."'";
            $convertedMarks = Yii::app()->db->createCommand($Sql)->queryScalar();
            if(!$convertedMarks){
                $Sql = "INSERT INTO student_overall_percent (student_ref_id, overall_12, added_on) VALUES ('".$this->studentID."', '".$objStudentMarks->overall."', '".date('Y-m-d H:i:s')."')";
                Yii::app()->db->createCommand($Sql)->execute();
            }
        }

        return $objStudentMarks;
    }

    private function _getUniversitiesWithDepartmentByCountry(){

        return TblUniversityMaster::getUniversityListByCountryDept($this->countryID, $this->departmentID);

    }

    private function _sortResultByScore(&$arr, $col) {

        $sort_col = array();

        foreach ($arr as $key => $row)
            $sort_col[$key] = $row[$col];

        array_multisort($sort_col, $this->sortOrder, $arr);
    }
}
