<?php

class AdmissionChancesEngine extends CComponent
{

    private $entry_requirements = null;
    private $student_marks = null;

    private $proceed_to_academics = false;
    private $standard_tests_score = 0;

    public function __construct($entry_requirements, $student_marks)
    {
        $this->entry_requirements = $entry_requirements;
        $this->student_marks = $student_marks;

//        echo "<pre>"; print_r($this->entry_requirements);
//        echo "<pre>"; print_r($this->student_marks); exit;
//        echo "<pre>"; print_r($this->entry_requirements->getStandardTests());
    }

    public function getAdmissionChances()
    {
        if(!is_object($this->entry_requirements) ||
            !is_object($this->entry_requirements->academicoverall) ||
            !is_object($this->student_marks) ||
            !$this->student_marks->overall  )
            return 0;

        $this->processAdmissionChancesForStandards();

        if($this->proceed_to_academics){
            
            $academics_score = $this->getAdmissionChancesForAcademics();
            if((int)$academics_score == 0)
                $academics_score = $this->getNewAcademicScore();

            return ($this->standard_tests_score + $academics_score);

        }else
            return 0;
    }

    public function getNewAcademicScore() {
        
        $acdmcOverAll  = $this->entry_requirements->academicoverall;
        $overallScore  = ($this->student_marks->overall/$acdmcOverAll->minrange) * $acdmcOverAll->weightage;

        $subjectsScore = 0;
        if($this->entry_requirements->getAcademicSubjectsCount()){
            foreach ($this->entry_requirements->getAcademicSubjects() as $uniSubjectName => $uniSubjectObj) {
                $stdSubject = $this->student_marks->getSubjectObject($uniSubjectName);
                $subjectsScore += ($stdSubject->subjectMarks/$uniSubjectObj->minrange) * $uniSubjectObj->weightage;
            }
        }
        return $this->roundNum( ($overallScore + $subjectsScore) - 20);
    }
    
    public function processAdmissionChancesForStandards(){

        $this->redistributeStandardTests();

        // check if the university/student does not contain any tests info
        if(count($this->entry_requirements->getStandardTests()) == 0 || count($this->student_marks->getStandardTests()) == 0){
            $this->proceed_to_academics = true;
            return;
        }
        else{

            foreach($this->entry_requirements->getStandardTests() as $testName => $testObj){

                $stdntTestOverAll = $this->student_marks->getStandardTestObject($testName)->standardTestOverAllMarks;
                $uniTestOverAllER  = $testObj->standardTestOverAll->minrange;
                $uniTestOverAllTolerance  = $testObj->standardTestOverAll->tolerance;

                if($this->entry_requirements->isQualifierTest($testName)){
                    if($stdntTestOverAll < ($uniTestOverAllER - $uniTestOverAllTolerance)){
                        $this->proceed_to_academics = false;
                        return;
                    }else
                        $this->proceed_to_academics = true;
                }else{
                    // do the logic for standard tests
                    if ($stdntTestOverAll < $uniTestOverAllER){
                        if($stdntTestOverAll < ($uniTestOverAllER - $testObj->standardTestOverAll->tolerance)){
                            $this->proceed_to_academics = false;
                            return;
                        }else {

                            if (count($this->entry_requirements->getSectionsByStandardTest($testName)) == 0) { // if university is not asking for any sections.
                                $this->standard_tests_score += $this->_getStandardsScoreForTest($testName);
                                $this->proceed_to_academics = true;
                            }else{

                                $failedSections = $this->_getFailedSectionsInTest($testName, ">");
                                if (count($failedSections) == 0) {
                                    $newEntryReq = $this->calculateNewEntryRequirementForTestOverAll($testName);
                                    if($stdntTestOverAll >= $newEntryReq) {
                                        $this->standard_tests_score += $this->_getStandardsScoreForTest($testName);
                                        $this->proceed_to_academics = true;
                                    }else{
                                        $this->proceed_to_academics = false;
                                        return;
                                    }
                                }else{
                                    $this->proceed_to_academics = false;
                                    return;
                                }
                            }
                        }
                    }elseif ($stdntTestOverAll >= $uniTestOverAllER){

                        if (count($this->entry_requirements->getSectionsByStandardTest($testName)) == 0) { // if university is not asking for any sections.
                            $this->standard_tests_score += $this->_getStandardsScoreForTest($testName);
                            $this->proceed_to_academics = true;
                        }else{

                            $failedSections = $this->_getFailedSectionsInTest($testName, ">=");
                            if (count($failedSections) == 0) {
                                $this->standard_tests_score += $this->_getStandardsScoreForTest($testName);
                                $this->proceed_to_academics = true;
                            }else{

                                $highWeightageSections = $this->entry_requirements->getHighestWeightageSectionsInTest($testName);
                                if (count($failedSections) == count($highWeightageSections) && count($highWeightageSections) > 1) {
                                    $this->proceed_to_academics = false;
                                    return;
                                }else{ // Student has failed in one section

                                    $failedSection = current($failedSections);

                                    $stdSectionObj = $this->student_marks->getStandardTestSectionObject($testName, $failedSection);
                                    $uniSectionObj = $this->entry_requirements->getStandardTestSectionObject($testName, $failedSection);

                                    // Apply tolerance for failed section
                                    if ($stdSectionObj->sectionMarks < ($uniSectionObj->minrange - $uniSectionObj->tolerance)) {
                                        $this->proceed_to_academics = false;
                                        return;
                                    }else{
                                        // Calculate tolerance level for section that has less marks
                                        $sectionNewER = $this->calculateNewEntryRequirementForSection($testName, $failedSection);
                                        if($stdSectionObj->sectionMarks >= $sectionNewER){
                                            $this->standard_tests_score += $this->_getStandardsScoreForTest($testName);
                                            $this->proceed_to_academics = true;
                                        }else{
                                            $this->proceed_to_academics = false;
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public function getAdmissionChancesForAcademics()
    {

        $this->redistributeAcademicsWeightages();

        $studentOverallMarks = $this->student_marks->overall;
        $academicoverall     = $this->entry_requirements->academicoverall;
        $overallEntryReq     = $academicoverall->minrange;
        $overallTolerance    = $academicoverall->tolerance;

        if ($studentOverallMarks < $overallEntryReq) {
            if ($studentOverallMarks < ($overallEntryReq - $overallTolerance)) {
                $score = 0;
                return $score;
            } else {
                if ($this->entry_requirements->getAcademicSubjectsCount() == 0) { // if university is not asking for any subject.
                    $score = $this->_getAcademicsScore();
                    return $score;
                } else {

                    $failedSubjects = $this->_getFailedSubjects(">");
                    if (count($failedSubjects) == 0) {
                        $newEntryReq = $this->calculateNewEntryRequirementForOverAll();
                        $score = ($studentOverallMarks >= $newEntryReq) ? $this->_getAcademicsScore() : 0;
                    } else {
                        $score = 0;
                    }
                    return $score;
                }
            }
        } elseif ($studentOverallMarks >= $overallEntryReq) {


            if ($this->entry_requirements->getAcademicSubjectsCount() == 0) { // if university is not asking for any subject.
                $score = $this->_getAcademicsScore();
                return $score;
            } else {

                $failedSubjects = $this->_getFailedSubjects(">=");
                if (count($failedSubjects) == 0) {
                    $score = $this->_getAcademicsScore();
                    return $score;

                } else {

                    $highWeightageSubjects = $this->entry_requirements->getHighestWeightageSubjects();
                    if (count($failedSubjects) == count($highWeightageSubjects) && count($highWeightageSubjects) > 1) {
                        $score = 0;
                        return $score;
                    } else { // Student has at least one subject marks is greater than university entry requirement.

                        $failedSubject = current($failedSubjects);

                        // Apply tolerance for less mark subject
                        $universityMinRange = $this->entry_requirements->getAcademicSubjectObject($failedSubject)->minrange;
                        $universityTolerance = $this->entry_requirements->getAcademicSubjectObject($failedSubject)->tolerance;

                        if ($this->student_marks->getMarksBySubject($failedSubject) < ($universityMinRange - $universityTolerance)) {
                            $score = 0;
                            return $score;
                        } else { // Calculate tolerance level for subject that has less marks

                            $subjectNewEntryRequirement = $this->calculateNewEntryRequirementForSubject($failedSubject);
                            $score = ($this->student_marks->getMarksBySubject($failedSubject) >= $subjectNewEntryRequirement) ? $this->_getAcademicsScore() : 0;
                            return $score;
                        }
                    }
                }
            }
        }
    }


    public function redistributeStandardTests()
    {
        $aUniTests      = array_keys($this->entry_requirements->getStandardTests());
        $aStudentTests  = array_keys($this->student_marks->getStandardTests());

        $uniTestsToRemove       = array_diff($aUniTests, $aStudentTests);
        $studentTestsToRemove   = array_diff($aStudentTests, $aUniTests);

        if (count($uniTestsToRemove)) {
            foreach ($uniTestsToRemove as $testName) {
                $this->entry_requirements->unsetStandardTestObject($testName); // remove test from unv object
            }
        }

        if (count($studentTestsToRemove)) {
            foreach ($studentTestsToRemove as $testName) {
                $this->student_marks->unsetStandardTestObject($testName); // remove test from student test object
            }
        }

        // Remove unneeded sections from student obj
        foreach($this->student_marks->getStandardTests() as $testName => $testObj){

            if($this->entry_requirements->isQualifierTest($testName)){
                $this->student_marks->unsetSectionsByTest($testName);
            }
            else{
                $uniTestSections    = array_keys($this->entry_requirements->getSectionsByStandardTest($testName));
                $stdntTestSections  = array_keys($this->student_marks->getSectionsByStandardTest($testName));
                $stdntTestSectionsToRemove   = array_diff($stdntTestSections, $uniTestSections);

                foreach($stdntTestSectionsToRemove as $sectionName)
                    $this->student_marks->unsetSectionsByTest($testName, $sectionName);
            }
        }

        $isAllTestsAreQualifierTests = true;
        // Redistribute and Remove unneeded sections from univ tests obj
        foreach($this->entry_requirements->getStandardTests() as $testName => $testObj){

            if($this->entry_requirements->isQualifierTest($testName)){
                // we dont consider sections, remove all
                $this->entry_requirements->unsetSectionsByTest($testName);
            }
            else{

                $isAllTestsAreQualifierTests = false;

                $uniTestSections    = array_keys($this->entry_requirements->getSectionsByStandardTest($testName));
                $stdntTestSections  = array_keys($this->student_marks->getSectionsByStandardTest($testName));
                $uniTestSectionsToRedistribute   = array_diff($uniTestSections, $stdntTestSections);

                foreach($uniTestSectionsToRedistribute as $sectionName){

                    // remove section from university test object
                    $this->entry_requirements->unsetSectionsByTest($testName, $sectionName);
                    // now get new section weightages sum
                    $weightageSum = $this->entry_requirements->getSectionWeightagesSumByTest($testName);

                    // Re-calculate test overall weightage
                    $newOverallWeightage = $this->roundNum((100 / $weightageSum) * $testObj->standardTestOverAll->weightage, 2);
                    $this->entry_requirements->getStandardTestObject($testName)->standardTestOverAll->weightage = $newOverallWeightage;

                    $testSections = $this->entry_requirements->getSectionsByStandardTest($testName);
                    // Re-calculate remaining sections weightages
                    foreach ($testSections as $sectionName => $sectionObj) {

                        $subjectWeightage = $this->entry_requirements->getStandardTestSectionObject($testName,$sectionName)->weightage;
                        $subjectNewWeightage = $this->roundNum((100 / $weightageSum) * $subjectWeightage, 2);
                        $this->entry_requirements->getStandardTestSectionObject($testName,$sectionName)->weightage = $subjectNewWeightage;
                    }
                }
            }
        }

        if($isAllTestsAreQualifierTests){

            // Redistribute Standard Exam Weightage to other master Weightages
            $this->entry_requirements->masterweightage->standardsweightage = 0;
            $weightageSum = $this->entry_requirements->getMasterWeightagesSum();

            $this->entry_requirements->masterweightage->academicsweightage = $this->roundNum((100 / $weightageSum) * $this->entry_requirements->masterweightage->academicsweightage, 2);

            $this->entry_requirements->masterweightage->workexperienceweightage = $this->roundNum((100 / $weightageSum) * $this->entry_requirements->masterweightage->workexperienceweightage, 2);

            $this->entry_requirements->masterweightage->extracuricullarweightage = $this->roundNum((100 / $weightageSum) * $this->entry_requirements->masterweightage->extracuricullarweightage, 2);

        }

    }
    public function redistributeAcademicsWeightages()
    {
        $uniSubjects = $this->entry_requirements->getAcademicSubjects();
        $stdSubjects = $this->student_marks->getSubjects();

        $aUniSubjects = array_keys($uniSubjects);
        $aStdSubjects = array_keys($stdSubjects);

        $uniSubjectsToRedistribute  = array_diff($aUniSubjects, $aStdSubjects);
        $stdSubjectsToRemove        = array_diff($aStdSubjects, $aUniSubjects);

        if (count($stdSubjectsToRemove)) {
            foreach ($stdSubjectsToRemove as $SubjectName) {
                $this->student_marks->unsetSubjectObject($SubjectName); // remove subject from student subject object
            }
        }

        if (count($uniSubjectsToRedistribute) == 0) {
            return;
        } // do nothing if student has provided all subjects that university is asking

        foreach ($uniSubjectsToRedistribute as $SubjectName) {

            // remove subject from university subjects object
            $this->entry_requirements->unsetAcademicSubjectObject($SubjectName);
            // now get new weightages sum
            $weightageSum = $this->entry_requirements->getAcademicWeightagesSum();

            // Re-calculate overall weightage
            $newOverallWeightage = $this->roundNum((100 / $weightageSum) * $this->entry_requirements->academicoverall->weightage, 2);
            $this->entry_requirements->academicoverall->weightage = $newOverallWeightage;

            $uniSubjects = $this->entry_requirements->getAcademicSubjects();
            // Re-calculate remaining subjects weightages
            foreach ($uniSubjects as $subject => $subjectData) {

                $subjectWeightage = $this->entry_requirements->getAcademicSubjectObject($subject)->weightage;
                $subjectNewWeightage = $this->roundNum((100 / $weightageSum) * $subjectWeightage, 2);
                $this->entry_requirements->getAcademicSubjectObject($subject)->weightage = $subjectNewWeightage;
            }

        }
    }

    public function compareEntrymarks($stdntMarks, $uniER, $operator = '>')
    {
        if ($operator == ">") {
            return $stdntMarks > $uniER;
        } elseif ($operator == ">=") {
            return $stdntMarks >= $uniER;
        } elseif ($operator == "<") {
            return $stdntMarks < $uniER;
        } elseif ($operator == "<=") {
            return $stdntMarks <= $uniER;
        } elseif ($operator == "==") {
            return $stdntMarks == $uniER;
        }

    }

    public function getNewToleranceValue($con1, $con2)
    {
        if($con1 === 0){
            return 0;
        }

        if ($con2 == '') {
            if ($con1 == 1) {
                return 70;
            } elseif ($con1 == 2) {
                return 100;
            } elseif ($con1 == 3) {
                return 100;
            }
        }

        if (($con1 == 1 && $con2 == 1)) {
            return 70;
        } else {
            return 100;
        }
        /*elseif (($con1 == 2 && $con2 == 2)
            || ($con1 == 1 && $con2 == 2)
            || ($con1 == 2 && $con2 == 1)
            || ($con1 == 1 && $con2 == 3)
            || ($con1 == 3 && $con2 == 1)
        ) {
            return 70;
        } elseif (($con1 == 3 && $con2 == 3)
            || ($con1 == 2 && $con2 == 3)
            || ($con1 == 3 && $con2 == 2)
        ) {
            return 100;
        }*/
    }

    public function getConditionValue($marks, $compareValue)
    {
        $ER = $compareValue->minrange;
        $HS = $compareValue->highrange;
        $AS = $this->_getAverageMarks($compareValue->minrange, $compareValue->highrange);

        $status = 0;
        if ($marks >= $ER && $marks < $AS ) {
            $status = 1;
        }

        if ($marks >= $AS && $marks < $HS) {
            $status = 2;
        }

        if ($marks >= $HS) {
            $status = 3;
        }

        return $status;
    }

    public function calculateNewEntryRequirementForSubject($failedSubject)
    {

        $uniSubjects = $this->entry_requirements->getHighestWeightageSubjects();
        unset($uniSubjects[$failedSubject]); // remove subject from university subject list

        // Evaluate for overall
        $marks = $this->student_marks->overall;
        $uniSubjectObj = $this->entry_requirements->academicoverall;
        $overallConditionValue = $this->getConditionValue($marks, $uniSubjectObj);

        $subjectConditionValue = '';
        if(count($uniSubjects) == 1){
            // Evaluate for subject
            $subject = key($uniSubjects);
            $marks = $this->student_marks->getMarksBySubject($subject);
            $uniSubjectObj = $this->entry_requirements->getAcademicSubjectObject($subject);
            $subjectConditionValue = $this->getConditionValue($marks, $uniSubjectObj);
        }

        $allowTolerance = $this->getNewToleranceValue($overallConditionValue, $subjectConditionValue);
        $uniSubjectObj = $this->entry_requirements->getAcademicSubjectObject($failedSubject);

        return ($uniSubjectObj->minrange - ($allowTolerance/100 * $uniSubjectObj->tolerance));
    }

    public function calculateNewEntryRequirementForOverAll()
    {
        $highWeightageSubjects = $this->entry_requirements->getHighestWeightageSubjects();

        $condResult = array();
        foreach ($highWeightageSubjects as $uniSubject => $value) {
            $uniSubjectObj = $this->entry_requirements->getAcademicSubjectObject($uniSubject);
            $condResult[] = $this->getConditionValue($this->student_marks->getMarksBySubject($uniSubject), $uniSubjectObj);
        }

        $allowTolerance = $this->getNewToleranceValue($condResult[0], isset($condResult[1]) ? $condResult[1] : '');
        $uniTolerance = $this->entry_requirements->academicoverall->tolerance;
        $uniMinrange = $this->entry_requirements->academicoverall->minrange;

        return ($uniMinrange - ($allowTolerance/100 * $uniTolerance));
    }

    public function calculateNewEntryRequirementForTestOverAll($testName)
    {
        $highWeightageSections = $this->entry_requirements->getHighestWeightageSectionsInTest($testName);

        $condResult = array();
        foreach ($highWeightageSections as $uniSectionName => $value) {
            $uniSectionObj = $this->entry_requirements->getStandardTestSectionObject($testName, $uniSectionName);
            $stdSectionObj = $this->student_marks->getStandardTestSectionObject($testName, $uniSectionName);
            $condResult[] = $this->getConditionValue($stdSectionObj->sectionMarks, $uniSectionObj);
        }

        $allowTolerance = $this->getNewToleranceValue($condResult[0], isset($condResult[1]) ? $condResult[1] : '');
        $uniTestOverAllObj = $this->entry_requirements->getStandardTestObject($testName)->standardTestOverAll;

        return ($uniTestOverAllObj->minrange - ($allowTolerance/100 * $uniTestOverAllObj->tolerance));
    }

    public function calculateNewEntryRequirementForSection($testName, $failedSection)
    {

        $highWeightageSections = $this->entry_requirements->getHighestWeightageSectionsInTest($testName);
        unset($highWeightageSections[$failedSection]); // remove subject from university subject list

        $stdntTestOverAll   = $this->student_marks->getStandardTestObject($testName)->standardTestOverAllMarks;
        $uniTestOverAllObj  = $this->entry_requirements->getStandardTestObject($testName)->standardTestOverAll;

        // Evaluate for overall
        $overallConditionValue = $this->getConditionValue($stdntTestOverAll, $uniTestOverAllObj);

        $sectionConditionValue = '';
        if(count($highWeightageSections) == 1){
            // Evaluate for section
            $section = key($highWeightageSections);
            $stdSectionObj = $this->student_marks->getStandardTestSectionObject($testName, $section);
            $uniSectionObj = $this->entry_requirements->getStandardTestSectionObject($testName, $section);
            $sectionConditionValue = $this->getConditionValue($stdSectionObj->sectionMarks, $uniSectionObj);
        }

        $allowTolerance = $this->getNewToleranceValue($overallConditionValue, $sectionConditionValue);
        $uniSectionObj = $this->entry_requirements->getStandardTestSectionObject($testName, $failedSection);

        return ($uniSectionObj->minrange - ($allowTolerance/100 * $uniSectionObj->tolerance));
    }


    public function roundNum($val, $defaultDecimal = 2)
    {
        return round($val, $defaultDecimal);
    }

    public function calculateData($marks, $minrange, $highrange, $weightage)
    {
        $AS = $this->_getAverageMarks($minrange,  $highrange);
        if(!$AS) return 0;

        return $this->roundNum( ($marks / $AS) * $weightage );
    }

    private function _getAverageMarks($minrange, $highrange){

        //$AS = ($minrange + $highrange) / 2;
        $AS = $minrange;

        return $AS;
    }

    private function _getAcademicsScore(){

        $acdmcOverAll  = $this->entry_requirements->academicoverall;
        $overallScore  = $this->calculateData($this->student_marks->overall, $acdmcOverAll->minrange, $acdmcOverAll->highrange, $acdmcOverAll->weightage);

        $subjectsScore = 0;
        if($this->entry_requirements->getAcademicSubjectsCount()){
            foreach ($this->entry_requirements->getAcademicSubjects() as $uniSubjectName => $uniSubjectObj) {

                $stdSubject = $this->student_marks->getSubjectObject($uniSubjectName);
                $subjectsScore += $this->calculateData($stdSubject->subjectMarks, $uniSubjectObj->minrange, $uniSubjectObj->highrange, $uniSubjectObj->weightage);
            }
        }

        return $this->roundNum( ($overallScore + $subjectsScore) * ($this->entry_requirements->masterweightage->academicsweightage) / 100 );
    }

    private function _getStandardsScoreForTest($testName){

        $uniTestOverAll   = $this->entry_requirements->getOverAllByStandardTest($testName);
        $stdntTestObj     = $this->student_marks->getStandardTestObject($testName);
        $overallScore     = $this->calculateData($stdntTestObj->standardTestOverAllMarks, $uniTestOverAll->minrange, $uniTestOverAll->highrange, $uniTestOverAll->weightage);

        $sectionsScore  = 0;
        $uniSections    = $this->entry_requirements->getSectionsByStandardTest($testName);
        if($uniSections && count($uniSections)){
            foreach ($uniSections as $uniSectionName => $uniSectionObj) {

                $stdntSectionObj = $this->student_marks->getStandardTestSectionObject($testName, $uniSectionName);
                $sectionsScore += $this->calculateData($stdntSectionObj->sectionMarks, $uniSectionObj->minrange, $uniSectionObj->highrange, $uniSectionObj->weightage);
            }
        }

        return $this->roundNum( ($overallScore + $sectionsScore) * ($this->entry_requirements->masterweightage->standardsweightage) / 100 );

    }

    private function _getFailedSubjects($compareOperator = ''){

        $failedSubjects = array();
        foreach ($this->entry_requirements->getHighestWeightageSubjects() as $UniSubjectName => $value) {
            $stdSubjectObj = $this->student_marks->getSubjectObject($UniSubjectName);
            $uniSubjectObj = $this->entry_requirements->getAcademicSubjectObject($UniSubjectName);
            if (!$this->compareEntryMarks($stdSubjectObj->subjectMarks, $uniSubjectObj->minrange, $compareOperator))
                $failedSubjects[] = $UniSubjectName;
        }

        return $failedSubjects;
    }

    private function _getFailedSectionsInTest($testName, $compareOperator = ''){

        $failedSections = array();
        foreach ($this->entry_requirements->getHighestWeightageSectionsInTest($testName) as $UniSectionName => $value) {
            $stdSectionObj = $this->student_marks->getStandardTestSectionObject($testName, $UniSectionName);
            $uniSectionObj = $this->entry_requirements->getStandardTestSectionObject($testName, $UniSectionName);
            if (!$this->compareEntryMarks($stdSectionObj->sectionMarks, $uniSectionObj->minrange, $compareOperator))
                $failedSections[] = $UniSectionName;
        }

        return $failedSections;
    }
}