<?php

class StudentRegistration extends CComponent {

    public $model;
    public $attributes_to_validate;
    public $login_url;
    public $critical_fields;

    public function __construct() {
        $this->login_url = Yii::app()->createUrl('login');
        $this->critical_fields = array('name' => 1,'gender' => 1,'study_level' => 1,'preferred_course_duration' => 1,'edu_study_level' => 1,'completion_year' => 1);
        $this->attributes_to_validate = array('first_name', 'last_name', 'username', 'present_class', 'phone', 'country_code', 'gender');
        $this->model = new StudentSignupB2C('new_signup');
    }

    public function validate_fields(){
        $errors = array();
        if (Yii::app()->request->isPostRequest) {
            $errors = json_decode(CActiveForm::validate($this->model, $this->attributes_to_validate), TRUE);			
            if (isset($errors[get_class($this->model).'_username']) && preg_match('/Email address already registered/i', $errors[get_class($this->model).'_username'][0])) {
                $errors[get_class($this->model).'_username'][0] = '<div class="holder"><p>Email already registered. <a href="' . $this->login_url . '">Login</a></p></div>';
            }
        }		 
        return $errors;
    }
    
    public function register($do_login = TRUE, $redirect_url = NULL, $with_class_data = TRUE) {
        
        if (Yii::app()->request->isPostRequest && !$this->validate_fields()) {

            $signup_data = Yii::app()->request->getParam(get_class($this->model));
            $this->model->setAttributes($signup_data, FALSE);
            $transaction = Yii::app()->db->beginTransaction();
			
            try {
                //$url_details = LookupUrl::getUrlByModel(array('model_name' => 'b2c_signup', 'class_level' => 12, 'label' => 'b2c_finish',), 1);
                $url_details = LookupUrl::getUrlByModel(array('model_name' => 'corePHP', 'class_level' => 0, 'label' => 'dashboard',), 1);
				
                $StudentSignup = new StudentSignup('new_signup');
                $uniqueId = md5($StudentSignup->getUniqueID("uid"));
                $StudentSignup->set_session("unique_id", $uniqueId);
				if(empty($signup_data['password'])) {
					$password = DiHelper::genPassword();
					$pwd_gen=1;
				}
				else { 
					$password =$signup_data['password'];
					$pwd_gen=0;
				}
                $login_master_data = array('username' => $signup_data['username'], 'pass_word' => $password, 'user_type_ref_id' => 1, 'is_active' => 1, 'is_email_confirmed' => 0, 'is_systempwd' => $pwd_gen, 'added_on' => date('Y-m-d H:i:s'));
                $LoginMaster = new LoginMaster;
                $LoginMaster->setAttributes($login_master_data, FALSE);
				
                if(!$LoginMaster->save(FALSE)) throw new CDbException('login master save failed');

                $user_uno = $StudentSignup->generateUserUNO('IN');
                $user_membership_ref_id = $StudentSignup->getMembershipId('Guest');

                $user_master_data = array(
                    'login_ref_id' => $LoginMaster->login_id,
                    'uno' => $user_uno,
                    'first_name' => ucwords(strtolower(trim($signup_data['first_name']))), 'last_name' => ucwords(strtolower(trim($signup_data['last_name']))),
                    'membership_ref_id' => $user_membership_ref_id['membership_id'],
                    'redirect_url_ref_id' => $url_details[0]['url_id'],
                    'profile_status_ref_id' => 3,
                    'added_on' => date('Y-m-d H:i:s'),
                );
                
                if($with_class_data){
                    $class_data = $this->_DynamicPassoutYearAndMonth($signup_data['present_class']);
                    $user_master_data['present_class'] = $class_data['present_class'];
                    $user_master_data['class_status'] = $class_data['class_status'];
                    $user_master_data['passout_year'] = $class_data['passout_year'];
                    $user_master_data['passout_month'] = $class_data['passout_month'];
                }
                
                if(isset($signup_data['gender'])) $user_master_data['gender'] = $signup_data['gender'];
                
                $TblUserMaster = new TblUserMaster;
                
                $TblUserMaster->setAttributes($user_master_data, FALSE);
                if(!$TblUserMaster->save(false)) throw new CDbException('user master save failed');

                StudentPreferredStudyLevel::addStudentPreferences($TblUserMaster->user_id, array(5));

                if(!empty($signup_data['country_code']) && !empty($signup_data['phone'])){
                    $StudentContactNumber = new StudentContactNumber;
                    $StudentContactNumber->user_ref_id = $TblUserMaster->user_id;
                    $StudentContactNumber->phone_type = 'Mobile';
                    $StudentContactNumber->contact_type_ref_id = 1;
                    $StudentContactNumber->country_code = $signup_data['country_code'];
                    $StudentContactNumber->number = $signup_data['phone'];
                    $StudentContactNumber->is_primary = 1;
                    $StudentContactNumber->added_by = $LoginMaster->login_id;
                    if(!$StudentContactNumber->save(FALSE)) throw new CDbException('student contact number save failed');
                }

                TblUserProfCriticalCompletion::updateCriticalFields($TblUserMaster->user_id, $this->critical_fields);
                $StudentSignup->setRbacAssignment('Student', $LoginMaster->login_id);

                $this->_send_welcome_mail($TblUserMaster->user_id);
				//If password is system generated then only credential mail has to be send
				if(empty($signup_data['password'])) {
					$this->_send_login_details_mail($signup_data['first_name'], $signup_data['username'], $password);
                }
                $transaction->commit();
                
                if($do_login) $this->_do_login($signup_data['username'], $redirect_url);
            } catch (Exception $exc) {
                $transaction->rollback();
                return $exc->getMessage();
            }
        }
        return TRUE;
    }

    private function _do_login($username, $redirect_url){
        $LoginMaster = new LoginMaster();
        $LoginMaster->skipPassword = TRUE;
        if($redirect_url) $LoginMaster->loginWithRedirect($username, null, $redirect_url);
        $LoginMaster->username = $username;
        $LoginMaster->login();
        return true;
    }
    
    public function _send_login_details_mail($firstname, $email, $password) {

        $email_body = CBaseController::renderInternal(Yii::app()->basePath . '/views/umail/email/_login_details.php', compact('firstname', 'email', 'password'), true);
        $email_header = CBaseController::renderInternal(Yii::app()->basePath . '/views/umail/email/_mail_header.php', array(), true);
        $email_footer = CBaseController::renderInternal(Yii::app()->basePath . '/views/umail/email/_mail_footer.php', array(), true);

        $message = array();
        $message['subject'] = 'Your login details';
        $message['body'] = $email_header . $email_body . $email_footer;
        $message['type'] = 'Signup';
        $message['toName'] = $firstname;
        $message['toEmail'] = $email;
        $message['apiKey'] = Yii::app()->params['emailCron']['curlKey'];
        $emailq = new EmailMessage;
        $emailq->addEmailMessage($message);
        return true;
    }

    private function _send_welcome_mail($user_id) {
        return $this->sendConfirmationEmail($user_id);
    }
    
    protected function _DynamicPassoutYearAndMonth($class) {
        $current_month = date('n');
        $year = date('Y');
        $return = array();
        switch ($class) {
            case '9p':
                $return['passout_year'] = ($current_month < 6) ? ($year + 3) : ($year + 4);
                $return['passout_month'] = 6;
                $return['present_class'] = 9;
                $return['class_status'] = 'Pursuing';
                break;
            case '10p':
                $return['passout_year'] = ($current_month < 6) ? ($year+2) : ($year+3);
                $return['passout_month'] = 6;
                $return['present_class'] = 10;
                $return['class_status'] = 'Pursuing';
                break;
            case '11p':
                $return['passout_year'] = ($current_month < 6) ? ($year+1) : ($year+2);
                $return['passout_month'] = 6;
                $return['present_class'] = 11;
                $return['class_status'] = 'Pursuing';
                break;
            case '12p':
                $return['passout_year'] = ($current_month < 6) ? ($year) : ($year+1);
                $return['passout_month'] = 6;
                $return['present_class'] = 12;
                $return['class_status'] = 'Pursuing';
                break;
            case '12c':
                $return['passout_year'] = 0;
                $return['passout_month'] = 0;
                $return['present_class'] = 12;
                $return['class_status'] = 'Completed';
                break;
        }
        return $return;
    }

    public function sendConfirmationEmail($userId) {
        $user = TblUserMaster::model()->findByPk($userId);
        $this->calculateLikelyStartPeriod($userId);
        if ($user) {
            if(ACTUALHOST == 'univariety.com'){
                $PROTOCOL = 'https://';
            }else{
                $PROTOCOL = 'http://';
            }
            $ACTUALHOST = 'univariety.com';
            //$BASEURL = $PROTOCOL.ACTUALHOST.'/app';
            $BASEURL = 'https://www.univariety.com/app';

            $sql = "SELECT subdomain_slug_name FROM tbl_si_students ts  LEFT JOIN tbl_si_di tsd ON tsd.inst_id = ts.inst_ref_id WHERE ts.user_ref_id = $userId";
            $cmd = Yii::app()->db->createCommand($sql);
            $res = $cmd->queryAll();

            if ($res) {
                $slug = $res[0]['subdomain_slug_name'] ? $res[0]['subdomain_slug_name'] : 'www';;
            } else {
                $slug = 'www';
            }

            $emailHeader = CBaseController::renderInternal(Yii::app()->basePath . '/modules/student/views/signup/mailTemplates/welcomeEmailHeader.php',array('BASEURL'=>$BASEURL),true);
            $emailFooter = CBaseController::renderInternal(Yii::app()->basePath . '/modules/student/views/signup/mailTemplates/welcomeEmailFooter.php',array('BASEURL'=>$BASEURL),true);

            $dbData = array(
                'user_ref_id'   => $userId,
                'added_on'       => date('Y-m-d H:i:s')
            );
            $model = new ConfirmationEmailTracker();
            $model->setAttributes($dbData);
            $model->save(false);

            $studentValidationTrackerId = $model->confirmation_email_tracker_id;
            //$mailOpenDateTracker = $BASEURL.'/student/signup/TrackValidation?img='.base64_encode($studentValidationTrackerId);
            $mailOpenDateTracker = $BASEURL.'/student/signup/TrackEmailValidation?img='.$user->loginRef->username;

            $profileUrl = $PROTOCOL.$slug.'.'.$ACTUALHOST.'/app/login/confirmEmail?id='.$studentValidationTrackerId.'&type=';
            $confirmProfileUrl = $PROTOCOL.$slug.'.'.$ACTUALHOST.'/app/login/loginRedirect?ref='.base64_encode($user->login_ref_id.'==='.$profileUrl.'1');
            //$profileLink = $PROTOCOL.$slug.'.'.$ACTUALHOST.'/app/login/loginRedirect?ref='.base64_encode($user->login_ref_id.'==='.$profileUrl.'2');
            $profileLink = $PROTOCOL.$slug.'.'.$ACTUALHOST.'/app/login/loginRedirect?ref='.base64_encode($user->login_ref_id.'==='.$profileUrl.'5');
            $shortListLink = $PROTOCOL.$slug.'.'.$ACTUALHOST.'/app/login/loginRedirect?ref='.base64_encode($user->login_ref_id.'==='.$profileUrl.'3');
            $webinar = $PROTOCOL.$slug.'.'.$ACTUALHOST.'/app/login/loginRedirect?ref='.base64_encode($user->login_ref_id.'==='.$profileUrl.'4');

            $emailBody = CBaseController::renderInternal(Yii::app()->basePath . '/modules/student/views/signup/mailTemplates/welcomeEmail.php',compact('BASEURL', 'mailOpenDateTracker', 'confirmProfileUrl', 'profileLink', 'shortListLink', 'webinar'),true);

            $EmailMessage = array();
            $EmailMessage['subject'] = 'Welcome to Univariety';
            $EmailMessage['body']    = $emailHeader . $emailBody . $emailFooter;
            $EmailMessage['type']    = 'StudentProfileValidation';
            $EmailMessage['siteUrl'] = $BASEURL;
            $EmailMessage['cc']      = '';
            $EmailMessage['toName']  = '';
            $EmailMessage['toEmail'] = $user->loginRef->username;
            $EmailMessage['apiKey']  = Yii::app()->params['emailCron']['curlKey'];

            $email  = new EmailMessage;
            $result = $email->addEmailMessage($EmailMessage);
            return $result;
        }
    }

    public function calculateLikelyStartPeriod($user_id) {
        $user = TblUserMaster::model()->findByPk($user_id);
        if ($user->passout_year) {
            $month = 0;
            if ($user->present_board_ref_id && (!$user->passout_month || ($user->passout_month < 1))) {
                switch ($user->present_board_ref_id) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $month = 2;
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $month = 6;
                        break;
                }
                $user->passout_month = $month;
                $user->save(false);
            } else {
                $month = $user->passout_month;
            }

            if ($month != 0) {
                $model = new LookupLikelyPeriod;
                $data = $model->findAll();

                foreach ($data as $likelyPreferredPeriod) {
                    $preferredPeriod = $likelyPreferredPeriod->attributes;
                    $rangeArray = range($preferredPeriod['from_month'], $preferredPeriod['to_month']);
                    foreach ($rangeArray as $month) {
                        $preferredPeriodMonthRelationArray[$month]['start'] = $preferredPeriod['from_month'];
                        $preferredPeriodMonthRelationArray[$month]['end'] = $preferredPeriod['to_month'];
                        $preferredPeriodMonthRelationArray[$month]['period_id'] = $preferredPeriod['period_id'];
                    }
                }

                $studentPreferredPeriodRef = array();
                $startPeriodMonth = $month;
                $startPeriodYear = $user->passout_year;

                for ($i = $startPeriodMonth; ; $i++) {
                    if (count($studentPreferredPeriodRef) == 3) {
                        break;
                    } else {
                        if (isset($preferredPeriodMonthRelationArray[$i]) && (!in_array($preferredPeriodMonthRelationArray[$i]['period_id'], $studentPreferredPeriodRef))) {
                            $studentPreferredPeriodRef[] = $preferredPeriodMonthRelationArray[$i]['period_id'];
                            $prefPeriodRel[] = array(
                                'from_month' => $preferredPeriodMonthRelationArray[$i]['start'],
                                'to_month' => $preferredPeriodMonthRelationArray[$i]['end'],
                                'year' => $startPeriodYear,
                                'period_ref_id' => $preferredPeriodMonthRelationArray[$i]['period_id'],
                                'user_ref_id' => $user_id,
                                'added_on' => date('Y-m-d H:i:s'),
                            );
                        }
                    }
                    if ($i == 12) {
                        $i = 0;
                        $startPeriodYear++;
                    }
                }

                //StudentPreferredPeriod::model()->deleteAll(array("condition" => "user_ref_id = '" . $user_id . "'"));
                // changed for feed log call back
                foreach(StudentPreferredPeriod::model()->findAll(array("condition" => "user_ref_id = '" . $user_id . "'")) as $_StudentPreferredPeriod) $_StudentPreferredPeriod->delete();
                foreach ($prefPeriodRel as $preferredPeriod) {
                    StudentPreferredPeriod::addStudentPreferences($preferredPeriod);
                }

                $criticalFields = array('likely_start_period' => 1);
                TblUserProfCriticalCompletion::updateCriticalFields($user_id, $criticalFields);
            }
        }




    }
    
}
