<?php

/**
 * Most common util funtions are included in this class
 * @author shiva
 *
 */
class CommonUtils{
    static $sessionArray = array();

    /**
     * Grabs the subdomain from the url, if exists.
     * @param string $url, Url of the current page
     * @param string $domain, Optional, default: www expected top domain eg: .info, .org etc.,
     * @return string|null, if subdomain exists returns the subdomain as string else null
     */
    public static function getSubdomain($url = null, $domain = '.com'){
        // If no url is passed, get the current url.
        $url = empty($url) ? $_SERVER['HTTP_HOST']: $url;
        // $parts = parse_url(strtolower($url));
        //$host = rtrim( ltrim($url, 'www.'), $domain);
        $host = rtrim( str_replace('www.', '', $url), $domain);
        $t = explode('.', $host);
        if(count($t) == 1){
            return null;
        }
        return $t[0];
    }

    /**
     * Returns the current url being accessed.
     * @return string
     */
    public static function getCurrentUrl(){
        $s = empty($_SERVER['HTTPS']) ? '' : ($_SERVER['HTTPS'] == 'on') ? 's' : '';
        $protocol = strtolower($_SERVER['SERVER_PROTOCOL']);
        $protocol =  substr($protocol, 0, strpos($protocol, '/')). $s;
        $port = ($_SERVER['SERVER_PORT'] == '80') ? '' : (':'.$_SERVER['SERVER_PORT']);
        return $protocol . '://' . $_SERVER['SERVER_NAME'] . $port . $_SERVER['REQUEST_URI'];
    }


    public static function checkPartnerSessionDetails(){
        include_once (dirname(__FILE__)."/../../../classes/UnserializeSession.php");		
        $slugName = UnserializeSession::getSessionValue('sPartnersSlug', 'subDomainSlugName');
        $slugAccountType  = UnserializeSession::getSessionValue('sPartnersSlug', 'accountType');
        $slugInstituteId = UnserializeSession::getSessionValue('sPartnersSlug', 'instituteID');


        //include_once(dirname(__FILE__)."/../../../app/protected/components/CommonUtils.php");
        $subDomainSlugName = self::getSubdomain();

        $tempArr = array();
        $sessionInstituteId = '';
        if(isset($_SESSION['sInstituteUnivariety'])){
            $tempArr = unserialize($_SESSION['sInstituteUnivariety']);
            $sessionInstituteId = $tempArr['InstId'];
        }
		
        $requestInstituteId = @base64_decode(Yii::app()->request->getQuery('sId'));//self::base64DecodeParamWithDefaultValue('sId');
		if($_SESSION['extadv']==0) {
			if((@count($_SESSION['sInstituteUnivariety']) == 0) || ($subDomainSlugName != $slugName) || ($slugInstituteId != $sessionInstituteId)){
				Yii::app()->request->redirect('/logout.php');
			}
		}
    }

    public static function getSessionValue($sessionName = '', $sessionField = ''){
        if(count(self::$sessionArray) == 0 && isset($_SESSION[$sessionName])){
            self::$sessionArray = unserialize($_SESSION[$sessionName]);
        }
        if(isset(self::$sessionArray[$sessionField])){
            return self::$sessionArray[$sessionField];
        }else{
            return null;
        }
    }

    public static function getCurrentBaseUrl(){
        $url = Yii::app()->params['cbasepath'];
        $urlParts = parse_url($url);
        $subDomain = self::getSubdomain();

        $scheme = empty($_SERVER['HTTPS']) ? 'http' : (($_SERVER['HTTPS'] == 'on') ? 'https' : '');

        $subDomainPart = null;
        if($subDomain){
            $subDomainPart = empty($subDomain) ? '' : $subDomain . '.';
            $urlParts['host'] = preg_replace('/^www\./', '', $urlParts['host']);
            //@todo Yii::app()->params['cbasepath'] is being set someother place, need to find out.
            $urlParts['host'] = preg_replace('/' . $subDomain . '\./', '', $urlParts['host']);
        }
        return $scheme . '://' . $subDomainPart . $urlParts['host'] .  @$urlParts['path'];
    }

    public static function getProtocol(){

        return Yii::app()->getRequest()->isSecureConnection ? 'https://' : 'http://';
    }

    //public static function getCurrentBaseUrl(){
    //    $url = Yii::app()->params['cbasepath'];
    //    $urlParts = parse_url($url);
    //    $subDomain = self::getSubdomain();
    //
    //    $subDomainPart = null;
    //    if($subDomain){
    //        $subDomainPart = empty($subDomain) ? '' : $subDomain . '.';
    //        $urlParts['host'] = ltrim($urlParts['host'], 'www.');
    //        //@todo Yii::app()->params['cbasepath'] is being set someother place, need to find out.
    //        $urlParts['host'] = ltrim($urlParts['host'], $subDomain . '.');
    //    }
    //    return $urlParts['scheme'] . '://' . $subDomainPart . $urlParts['host'] .  @$urlParts['path'];
    //}

    public static function IndianMoneyFormat($price=0){
        $obj = new IndianMoneyFormat();
        $obj->price = $price;
        $obj->run();
        return $obj->price;
    }

    public static function getRbacUserRole($loginRefId=0){
        if(!Yii::app()->user->isGuest){
            $role = Yii::app()->authManager->getRoles($loginRefId);
            $roleArray = array_keys($role);
            return $roleArray[0] ?: '0';
        }else{
            return 'Guest';
        }
    }

    public static function generateMonthsDropDown($monthFormat = 'F'){
        $monthsArray = array();
        for($i=1; $i<=12; $i++){
            $monthsArray[$i] = date('F', strtotime(date('Y-'.$i.'-1')));
        }
        return $monthsArray;
    }

    public static function calculateCriticalPercentage($userId){
        $criticalFieldsArray[12] = array('country', 'likely_start_period', 'study_level', 'preferred_course_duration', 'intended_subjects', 'name', 'dob', 'gender', 'phone', 'citizenship', 'edu_study_level', 'school_name', 'completion_year', 'board');
        $criticalFieldsArray[9] = array('country', 'name', 'dob', 'gender', 'phone', 'citizenship', 'edu_study_level', 'school_name', 'completion_year', 'board', 'curriculum', 'career', 'like_subjects', 'interest');
		$userCriticalPercentage = 0;

        $userInfo = TblUserMaster::getUserDetails($userId);
        $userCiricalFields = $userInfo->tblUserProfCriticalCompletion->attributes;
		if(count($userCiricalFields) > 0){
			array_shift($userCiricalFields);
	
			switch($userInfo->present_class){
				case 12:
				case 11:{
					$classLevel = 12;
					break;
				}
				case 10:
				case 9:{
					$classLevel = 9;
					break;
				}
			}
			$userCriticalFieldCount = 0;
            if($criticalFieldsArray[$classLevel]){
			foreach($criticalFieldsArray[$classLevel] as $key){
				if($userCiricalFields[$key]){
					$userCriticalFieldCount++;
				}
			}
			$criticalFieldCount = count($criticalFieldsArray[$classLevel]);
			$userCriticalPercentage = round(($userCriticalFieldCount/count($criticalFieldsArray[$classLevel]))*100);
            }
		}
        $model = TblUserMaster::model()->find(array("condition" => "user_id = $userId"));
        $model->setAttributes(array('user_id' => $userId, 'critical_percent' => $userCriticalPercentage));
        $model->save();
        return $userCriticalPercentage;
    }

    public static function checkUserRedirection($userId=0, $currentAction=''){
        $userInfo = TblUserMaster::getUserDetails($userId);
        $redirctUrlId = $userInfo->attributes['redirect_url_ref_id'];

        $urlDetails = LookupUrl::getUrlByModel(array("url_id" => $redirctUrlId));
        $url = $urlDetails[0]['url'];
        $url = str_replace('{USER_ID}',$userId,$url);
        $requiredAction = strtolower(substr($url, strrpos($url, '/')+1, strlen($url)));

        $currentAction = strtolower($currentAction);
        if($currentAction == $requiredAction){
            return true;
        }else{
            //Yii::app()->redirect($url);
            //header('Location: '.$url);
            self::jsRedirect($url);
        }
    }

    // this function is created for back and forth functionlity
    // if user once complete sign up process then user cannot come back on sign up steps pages.
    public static function isSignupStepComplete($userId=0, $currentAction=''){
        $userInfo = TblUserMaster::getUserDetails($userId);
        $redirctUrlId = $userInfo->attributes['redirect_url_ref_id'];
        if($redirctUrlId == 14) {
            $urlDetails = LookupUrl::getUrlByModel(array("url_id" => $redirctUrlId));
            $url = $urlDetails[0]['url'];
            $url = str_replace('{USER_ID}',$userId,$url);
            self::jsRedirect($url);
        }
    }
    
    public static function jsRedirect($url=''){
        echo '<script>';
        echo 'window.location.href="'.$url.'"';
        echo '</script>';
    }

    static public function getFullName($loginID = 0){
        $loginMaster = LoginMaster::model()->findByPk($loginID);
        if(!$loginMaster){ return false; }
        $fullName = '';
        switch($loginMaster->user_type_ref_id){
            case '1':
            case '5':
                $obj = Student::model()->findByAttributes(array('login_ref_id' => $loginID));
                $fullName = $obj->first_name .' '.$obj->last_name;
                break;
            case '2':
                $obj = TblSiDi::model()->findByAttributes(array('login_ref_id' => $loginID));
                $fullName = $obj->inst_name;
                if($obj->inst_id == ''){
                    $obj = Admin::model()->findByAttributes(array('login_ref_id' => $loginID));
                    $fullName = $obj->admin_name;
                }
                break;
            case '3':
                Yii::import('application.modules.di.models.*');
                $obj = DiUser::model()->findByAttributes(array('login_ref_id' => $loginID));
                $fullName = $obj->first_name .' '.$obj->last_name;
                break;
            case '4':
                $obj = Admin::model()->findByAttributes(array('login_ref_id' => $loginID));
                if($obj) $fullName = $obj->admin_name;
                break;
            case '6':
                Yii::import('application.modules.vendor.models.*');
                $obj = VendorContact::model()->findByAttributes(array('login_ref_id' => $loginID));
                if($obj){
                    $fullName = $obj->first_name .' '.$obj->last_name;
                }else{
                    $obj = VendorCentreContact::model()->findByAttributes(array('login_ref_id' => $loginID));
                    $fullName = $obj->first_name .' '.$obj->last_name;
                }
                break;
            case '7':
                $obj = FranchiseInfo::model()->findByAttributes(array('login_ref_id' => $loginID));
                if($obj){
                    $fullName = $obj->first_name .' '.$obj->last_name;
                }
                break;
            case '8':
                Yii::import('application.modules.ctp.models.*');
                $obj = CtpInfo::model()->findByAttributes(array('login_ref_id'=>$loginID));
                if($obj){
                    $fullName = $obj->first_name .' '.$obj->last_name;
                }
                break;
            case '9':
                $obj = LorTeachersInfo::model()->findByAttributes(array('login_ref_id' => $loginID));
                if($obj){
                    $fullName = $obj->first_name .' '.$obj->last_name;
                }
                break;
            case '10':
                $obj = LorOthersInfo::model()->findByAttributes(array('login_ref_id' => $loginID));
                if($obj){
                    $fullName = $obj->first_name .' '.$obj->last_name;
                }
                break;
        }

        return $fullName ? ucwords($fullName) : 'User';
    }
}
